<?php
/**
 * Webhooks: Subscription Cancel
 *
 * @package SimplePay\Pro\Webhooks
 * @since 4.10.0
 */

namespace SimplePay\Pro\Webhooks;

use SimplePay\Core\API;
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Webhook_Subscription_Cancel class.
 *
 * @since 4.10.0
 */
class Webhook_Subscription_Cancel extends Webhook_Base implements Webhook_Interface {


	/**
	 * Cancels a subscription.
	 *
	 * @since 4.10.0
	 * @return void
	 */
	public function handle() {
		$subscription = $this->event->data->object; // @phpstan-ignore-line

		// We can't safely proceed if we are unable to identify the Payment Form
		// this webhook originated from.
		if ( ! isset( $subscription->metadata->simpay_form_id ) ) {
			return;
		}

		$form_id = isset( $subscription->metadata->simpay_form_id )
			? $subscription->metadata->simpay_form_id
			: 0;
		$form    = simpay_get_form( $form_id );

		if ( false === $form ) {
			return;
		}

		// Retrieve the Subscription.
		$subscription = API\Subscriptions\retrieve(
			array(
				'id'     => $subscription->id, // @phpstan-ignore-line
				'expand' => array(
					'customer',
					'latest_invoice.payment_intent',
					'pending_setup_intent',
					'default_payment_method',
				),
			),
			$form->get_api_request_args()
		);

		do_action( 'simpay_webhook_subscription_cancel', $this->event, $subscription );
	}
}
