<?php
/**
 * Webhook: Payment Intent Processing
 *
 * @package SimplePay
 * @since 4.10.0
 */

namespace SimplePay\Pro\Webhooks;

use SimplePay\Core\API;
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Webhook_Payment_Intent_Processing class.
 *
 * @since 4.10.0
 */
class Webhook_Payment_Intent_Processing extends Webhook_Base implements Webhook_Interface {

	/**
	 * Stripe Payment Intent.
	 *
	 * @var \SimplePay\Vendor\Stripe\PaymentIntent
	 * @since 4.10.0
	 */
	public $payment_intent;

	/**
	 * Handle the Webhook's data.
	 *
	 * @since 4.10.0
	 */
	public function handle() {
		$payment_intent = $this->event->data->object;

		// Look directly in the PaymentIntent metadata for one-time payments.
		if ( isset( $payment_intent->metadata->simpay_form_id ) ) {
			$form_id = $payment_intent->metadata->simpay_form_id;

			// Look to see if the metadata exists in the Subscription's Invoice PaymentIntent (recurring payment).
		} elseif ( isset( $payment_intent->invoice ) ) {
			$payment_intent = API\PaymentIntents\retrieve(
				array(
					'id'     => $payment_intent->id,
					'expand' => array(
						'invoice.subscription',
					),
				),
				array(
					'api_key' => simpay_get_secret_key(),
				)
			);

			if (
				! isset(
					$payment_intent->invoice,
					$payment_intent->invoice->subscription,
					$payment_intent->invoice->subscription->metadata->simpay_form_id
				)
			) {
				return;
			}

			$form_id = $payment_intent->invoice->subscription->metadata->simpay_form_id;
		} else {
			return;
		}

		$form = simpay_get_form( $form_id );

		if ( false === $form ) {
			return;
		}

		// Retreive again with Customer expanded.
		$this->payment_intent = API\PaymentIntents\retrieve(
			array(
				'id'     => $payment_intent->id,
				'expand' => array(
					'customer',
					'payment_method',
				),
			),
			$form->get_api_request_args()
		);

		/**
		 * Allow processing of the Payment Intent.
		 *
		 * @since 4.10.0
		 *
		 * @param \SimplePay\Vendor\Stripe\Event         $event Stripe webhook event.
		 * @param \SimplePay\Vendor\Stripe\PaymentIntent $payment_intent Stripe PaymentIntent.
		 * @param \SimplePay\Core\Abstracts\Form         $form Form object.
		 */
		do_action(
			'simpay_webhook_payment_intent_processing',
			$this->event,
			$this->payment_intent,
			$form
		);
	}
}
