<?php
/**
 * Form Builder: Notifications
 *
 * @package SimplePay\Pro
 * @copyright Copyright (c) 2023, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 4.7.9
 */

namespace SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form;

use Sandhills\Utils\Persistent_Dismissible;
use SimplePay\Core\Settings;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Outputs markup for the "Payment Receipt Message" setting.
 *
 * @since 4.7.9
 * @access private
 *
 * @param int $post_id Current post ID (Payment Form ID).
 */
function _add_payment_notification_message( $post_id ) {
	$settings_url = Settings\get_url(
		array(
			'section' => 'emails',
		)
	);

	$dismissed_notice = (bool) Persistent_Dismissible::get(
		array(
			'id' => 'simpay-form-settings-notifications-education',
		)
	);

	if ( true !== $dismissed_notice ) {
		// @todo use a ViewLoader
		include_once SIMPLE_PAY_DIR . '/views/admin-education-payment-form-notifications-settings.php'; // @phpstan-ignore-line
	}
	?>

	<table>
		<tbody class="simpay-panel-section">
			<tr class="simpay-panel-field">
				<th>
					<label for="_success_redirect_type">
						<?php esc_html_e( 'Payment Receipt', 'simple-pay' ); ?>
					</label>
				</th>
				<td style="border-bottom: 0; padding-bottom: 0;">
					<?php
					$settings_url = Settings\get_url(
						array(
							'section'    => 'emails',
							'subsection' => 'payment-confirmation',
						)
					);

					$message = get_post_meta(
						$post_id,
						'_email_confirmation_message',
						true
					);

					wp_editor(
						$message,
						'_email_confirmation_message',
						array(
							'textarea_name' => '_email_confirmation_message',
							'textarea_rows' => 10,
						)
					);
					?>

					<p class="description">
						<?php
						echo wp_kses(
							sprintf(
								/* translators: %1$s Opening anchor tag, do not translate. %2$s Closing anchor tag, do not translate. */
								__(
									'Enter a custom email message to send to the customer after a successful payment has been made with this payment form. Leave blank to use your %1$sglobal email setting%2$s.',
									'simple-pay'
								),
								sprintf(
									'<a href="%s" target="_blank">',
									esc_url( $settings_url )
								),
								'</a>'
							),
							array(
								'a' => array(
									'href'   => true,
									'target' => true,
								),
							)
						);
						?>
					</p>
				</td>
			</tr>

			<tr class="simpay-panel-field">
				<th>
					<label for="_success_redirect_type">
						<?php esc_html_e( 'Payment Notification', 'simple-pay' ); ?>
					</label>
				</th>
				<td>
					<?php
					$settings_url = Settings\get_url(
						array(
							'section'    => 'emails',
							'subsection' => 'payment-notification',
						)
					);

					$message = get_post_meta(
						$post_id,
						'_email_notification_message',
						true
					);

					wp_editor(
						$message,
						'_email_notification_message',
						array(
							'textarea_name' => '_email_notification_message',
							'textarea_rows' => 10,
						)
					);
					?>

					<p class="description">
						<?php
						echo wp_kses(
							sprintf(
								/* translators: %1$s Opening anchor tag, do not translate. %2$s Closing anchor tag, do not translate. */
								__(
									'Enter a custom email message to notify yourself when a succesful payment has been made with this payment form. Leave blank to use your %1$sglobal email settings%2$s.',
									'simple-pay'
								),
								sprintf(
									'<a href="%s" target="_blank">',
									esc_url( $settings_url )
								),
								'</a>'
							),
							array(
								'a' => array(
									'href'   => true,
									'target' => true,
								),
							)
						);
						?>
					</p>
				</td>
			</tr>
		</tbody>
	</table>

	<?php
}
add_action(
	'simpay_form_settings_notifications_panel',
	__NAMESPACE__ . '\\_add_payment_notification_message',
	20
);
