<?php
/**
 * Custom Field: Custom Amount
 *
 * @package SimplePay\Pro\Post_Types\Simple_Pay\Edit_Form\Custom_Fields
 * @copyright Copyright (c) 2022, Sandhills Development, LLC
 * @license http://opensource.org/licenses/gpl-2.0.php GNU Public License
 * @since 3.9.0
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$counter = absint( $counter );

$legacy_label = simpay_get_saved_meta(
	get_the_ID(),
	'_custom_amount_label',
	''
);

$value = ! empty( $field['label'] )
	? $field['label']
	: $legacy_label;

// "Prefill with default amount" checkbox attributes.
$prefill_default_id = sprintf(
	'simpay-custom-amount-prefill-default-%s',
	$counter
);

$prefill_default_name = sprintf(
	'_simpay_custom_field[custom_amount][%s][prefill_default]',
	$counter
);
?>

<tr class="simpay-panel-field">
	<td colspan="2" style="padding-top: 12px;">
		<div class="notice inline notice-info">
			<p>
				<?php
				esc_html_e(
					'This is where the amount input will appear if the selected price option allows custom amounts.',
					'simple-pay'
				);
				?>
			</p>
		</div>
	</td>
</tr>

<tr class="simpay-panel-field">
	<th>
		<label for="simpay-custom-amount-label"><?php esc_html_e( 'Label', 'simple-pay' ); ?></label>
	</th>
	<td>
		<?php
		simpay_print_field(
			array(
				'type'        => 'standard',
				'subtype'     => 'text',
				'name'        => '_simpay_custom_field[custom_amount][' . $counter . '][label]',
				'id'          => 'simpay-custom-amount-label',
				'value'       => $value,
				'class'       => array(
					'simpay-field-text',
					'simpay-label-input',
				),
				'attributes'  => array(
					'data-field-key' => $counter,
				),
				'description' => simpay_form_field_label_description(),
			)
		);
		?>
	</td>
</tr>

<tr class="simpay-panel-field">
	<th>
		<label for="<?php echo 'simpay-custom-amount-placeholder-' . $counter; ?>"><?php esc_html_e( 'Placeholder', 'simple-pay' ); ?></label>
	</th>
	<td>
		<?php

		simpay_print_field(
			array(
				'type'        => 'standard',
				'subtype'     => 'text',
				'name'        => '_simpay_custom_field[custom_amount][' . $counter . '][placeholder]',
				'id'          => 'simpay-custom-amount-placeholder',
				'value'       => isset( $field['placeholder'] ) ? $field['placeholder'] : '{{amount}}',
				'class'       => array(
					'simpay-field-text',
				),
				'attributes'  => array(
					'data-field-key' => $counter,
				),
				'description' => esc_html__(
					'A short hint shown when the field is empty. Use {{amount}} to show the selected price option\'s amount.',
					'simple-pay'
				),
			)
		);

		?>
	</td>
</tr>

<tr class="simpay-panel-field">
	<th>
		<label for="<?php echo esc_attr( $prefill_default_id ); ?>">
			<?php
			esc_html_e( 'Prefill input with default price amount', 'simple-pay' );
			?>
		</label>
	</th>
	<td>
		<?php
		simpay_print_field(
			array(
				'type'        => 'checkbox',
				'name'        => $prefill_default_name,
				'id'          => $prefill_default_id,
				'value'       => isset( $field['prefill_default'] )
					? $field['prefill_default']
					: '',
				'description' => '',
			)
		);

		?>
	</td>
</tr>

<tr class="simpay-panel-field">
	<?php
	simpay_print_field(
		array(
			'type'        => 'default-value',
			'label'       => esc_html__( 'Default Amount', 'simple-pay' ),
			'id'          => 'simpay-custom-amount-default-' . $counter,
			'name'        => '_simpay_custom_field[custom_amount][' . $counter . '][default]',
			'value'       => isset( $field['default'] ) ? $field['default'] : '',
			'description' => esc_html__(
				'A default value will override the default price option amount. The default price option must allow a user-defined amount. The amount is in the currency\'s smallest decimal.',
				'simple-pay'
			),
		)
	);
	?>
</tr>

<tr class="simpay-panel-field">
	<td>
		<details>
			<summary style="padding: 18px 0 0; cursor: pointer;">
				<?php esc_html_e( 'Advanced', 'simple-pay' ); ?>
			</summary>

			<div style="margin-top: 10px;">
				<label for="<?php echo 'simpay-custom-amount-input-type-' . $counter; ?>" style="display: block; font-weight: bold; margin-bottom: 4px;">
					<?php esc_html_e( 'Input Type', 'simple-pay' ); ?>
				</label>
				<?php
				simpay_print_field(
					array(
						'type'        => 'select',
						'name'        => '_simpay_custom_field[custom_amount][' . $counter . '][input_type]',
						'id'          => 'simpay-heading-level-' . $counter,
						'value'       => isset( $field['input_type'] ) ? $field['input_type'] : 'tel',
						'options'     => array(
							'tel'    => esc_html__( 'Telephone', 'simple-pay' ),
							'number' => esc_html__( 'Number', 'simple-pay' ),
							'text'   => esc_html__( 'Text', 'simple-pay' ),
						),
						'attributes'  => array(
							'data-field-key' => $counter,
						),
						'description' => esc_html__(
							'Different devices present different keyboards for different input types.',
							'simple-pay'
						),
					)
				);
				?>
			</div>
		</details>
	</td>
</tr>
