/** Wonderplugin Audio Player Plugin Trial Version
 * Copyright 2023 Magic Hills Pty Ltd All Rights Reserved
 * Website: http://www.wonderplugin.com
 * Version 11.7 
 */
var AmazingAudioPlatforms={html5VideoSupported:function(){return!!document.createElement("video").canPlayType},isChrome:function(){return navigator.userAgent.match(/Chrome/i)!=null},isFirefox:function(){return navigator.userAgent.match(/Firefox/i)!=null},isOpera:function(){return navigator.userAgent.match(/Opera/i)!=null},isSafari:function(){return navigator.userAgent.match(/Version\/[\d\.]+.*Safari/)!=null},safariVersion:function(){var safariVersion=0;if(this.isSafari()){var match=navigator.userAgent.match(/Version\/([0-9]+)/);
safariVersion=match&&match.length>=2?parseInt(match[1],10):0}return safariVersion},isAndroid:function(){return navigator.userAgent.match(/Android/i)!=null},isIPad:function(){return navigator.userAgent.match(/iPad/i)!=null},isIPhone:function(){return navigator.userAgent.match(/iPod/i)!=null||navigator.userAgent.match(/iPhone/i)!=null},isIOS:function(){return this.isIPad()||this.isIPhone()},isMobile:function(){return this.isIPad()||this.isIPhone()||this.isAndroid()},isIE11:function(){return navigator.userAgent.match(/Trident\/7/)!=
null&&navigator.userAgent.match(/rv:11/)!=null},isIE:function(){return(navigator.userAgent.match(/MSIE/i)!=null||this.isIE11())&&!this.isOpera()},isIE9:function(){return navigator.userAgent.match(/MSIE 9/i)!=null&&!this.isOpera()},isIE8:function(){return navigator.userAgent.match(/MSIE 8/i)!=null&&!this.isOpera()},isIE7:function(){return navigator.userAgent.match(/MSIE 7/i)!=null&&!this.isOpera()},isIE6:function(){return navigator.userAgent.match(/MSIE 6/i)!=null&&!this.isOpera()},isIE678:function(){return this.isIE6()||
this.isIE7()||this.isIE8()},isIE6789:function(){return this.isIE6()||this.isIE7()||this.isIE8()||this.isIE9()},css33dTransformSupported:function(){return!this.isIE6()&&!this.isIE7()&&!this.isIE8()&&!this.isIE9()&&!this.isOpera()},autoplayDisabled:function(){return this.isMobile()||this.isSafari()&&this.safariVersion()>=11},applyBrowserStyles:function(object,applyToValue){var ret={};for(var key in object){ret[key]=object[key];ret["-webkit-"+key]=applyToValue?"-webkit-"+object[key]:object[key];ret["-moz-"+
key]=applyToValue?"-moz-"+object[key]:object[key];ret["-ms-"+key]=applyToValue?"-ms-"+object[key]:object[key];ret["-o-"+key]=applyToValue?"-o-"+object[key]:object[key]}return ret}};
(function($){$.fn.wonderpluginaudio=function(options){var amEscapeHtml=function(str){var tag=document.createElement("div");tag.innerHTML=str;return tag.innerText.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;")};var replaceMacro=function(titleformat,data,duration,downloadbutton,sharebutton){var t=titleformat.replace(/%DOWNLOADBUTTON%/g,downloadbutton);t=t.replace(/%SHAREBUTTON%/g,sharebutton);t=t.replace(/%TITLE%/g,data.title);t=t.replace(/%ALBUM%/g,
data.album);t=t.replace(/%ARTIST%/g,data.artist);t=t.replace(/%INFO%/g,data.info);t=t.replace(/%DURATION%/g,duration);t=t.replace(/%ID%/g,data.id);t=t.replace(/%ORDER%/g,data.id);if(data.source.length>0){var src=data.source[0].src?data.source[0].src:"";var file=src.lastIndexOf("/")>=0?src.substring(src.lastIndexOf("/")+1):src;t=t.replace(/%AUDIO%/g,src);t=t.replace(/%AUDIOURL%/g,src);t=t.replace(/%AUDIOFILE%/g,file)}return t};var PlayerSkin=function(amazingPlayer,container,options,id){this.amazingPlayer=
amazingPlayer;this.options=options;this.id=id;this.container=container;this.playerwrapper=$("<div class='amazingaudioplayer-player-wrapper"+(this.options.enabletabindex?" amazingaudioplayer-tabindex":"")+"'></div>");this.playerwrapper.appendTo(this.container);this.volumeSaved=1;var instance=this;var isTouch="ontouchstart"in window;var eStart=isTouch?"touchstart mousedown":"mousedown";var eMove=isTouch?"touchmove mousemove":"mousemove";var eCancel=isTouch?"touchcancel mouseup":"mouseup";var formatSeconds=
function(secs){var hours=Math.floor(secs/3600),minutes=Math.floor(secs%3600/60),seconds=Math.round(secs%3600%60);if(instance.options.customtimestyle)return instance.options.timestyle.replace("%HOURS%",hours).replace("%MINUTES%",minutes).replace("%SECONDS%",seconds);else return(hours==0?"":hours>0&&hours.toString().length<2?"0"+hours+":":hours+":")+(minutes.toString().length<2?"0"+minutes:minutes)+":"+(seconds.toString().length<2?"0"+seconds:seconds)};if(this.options.showbackgroundimage)this.playerwrapper.css({"background-image":'url("'+
this.options.backgroundimage+'")'});if(this.options.showimage){this.$image=$("<div class='amazingaudioplayer-image'></div>");this.$image.appendTo(this.playerwrapper);this.$image.css({width:this.options.imagefullwidth?"100%;":this.options.imagewidth+"px",height:this.options.imageheight+"px",display:"block"});this.container.on("amazingaudioplayer.updateinfo",function(event,data){if(data.image.length>0)instance.$image.html("<div class='amazingaudioplayer-image-space' style='display:inline-block;vertical-align:middle;height:100%;'></div><img alt='"+
amEscapeHtml(data.title)+"' src='"+data.image+"' style='width:100%;max-width:100%;vertical-align:middle;' />");else instance.$image.empty()});this.playerwrapper.append("<div class='amazingaudioplayer-image-clear'></div>")}if(this.options.showtitle||this.options.showinfo){this.$text=$("<div class='amazingaudioplayer-text'></div>");this.$text.appendTo(this.playerwrapper);if(this.options.showtitle){this.$title=$("<div class='amazingaudioplayer-title'></div>");this.$title.appendTo(this.$text);this.container.on("amazingaudioplayer.updateinfo",
function(event,data){var duration=data.duration?formatSeconds(data.duration):"";var t=replaceMacro(instance.options.titleformat,data,duration,instance.options.downloadbutton,instance.options.sharebutton);instance.$title.html(t)});this.$text.append("<div class='amazingaudioplayer-title-clear'></div>")}if(this.options.showinfo){this.$info=$("<div class='amazingaudioplayer-info'></div>");this.$info.appendTo(this.$text);this.container.on("amazingaudioplayer.updateinfo",function(event,data){var duration=
data.duration?formatSeconds(data.duration):"";var t=replaceMacro(instance.options.infoformat,data,duration,instance.options.downloadbutton,instance.options.sharebutton);instance.$info.html(t)});this.$text.append("<div class='amazingaudioplayer-info-clear'></div>")}this.playerwrapper.append("<div class='amazingaudioplayer-text-clear'></div>")}var $bar=$("<div class='amazingaudioplayer-bar'></div>");$bar.appendTo(this.playerwrapper);this.playerwrapper.append("<div class='amazingaudioplayer-bar-clear'></div>");
if(this.options.showbarbackgroundimage)$bar.css({"background-image":'url("'+this.options.barbackgroundimage+'")'});var $playpause=$("<div class='amazingaudioplayer-playpause'></div>");$playpause.appendTo($bar).css({display:"block"});var $play=$("<div class='amazingaudioplayer-play'></div>");$play.appendTo($playpause).css({display:"block",width:this.options.playpauseimagewidth,height:this.options.playpauseimageheight,cursor:"pointer"});if(!this.options.playpausefont)$play.css({"background-image":'url("'+
this.options.playpauseimage+'")',"background-repeat":"no-repeat","background-position":"left top"});else $play.addClass("mhicon-play").css({"text-align":"center","line-height":this.options.playpauseimageheight+"px","font-size":this.options.playpausefontsize+"px",color:this.options.playpausefontcolor,"background-color":this.options.playpausefontbgcolor,"border-radius":this.options.playpausefontcircle?"100%":this.options.playpausefontradius+"px"});if(!isTouch||!this.options.disablehoverontouch)$play.hover(function(){if(!instance.options.playpausefont)$(this).css({"background-position":"left bottom"});
else $(this).css({color:instance.options.playpausefonthovercolor,"background-color":instance.options.playpausefonthoverbgcolor})},function(){if(!instance.options.playpausefont)$(this).css({"background-position":"left top"});else $(this).css({color:instance.options.playpausefontcolor,"background-color":instance.options.playpausefontbgcolor})});var $pause=$("<div class='amazingaudioplayer-pause'></div>");$pause.appendTo($playpause).css({display:"none",width:this.options.playpauseimagewidth,height:this.options.playpauseimageheight,
cursor:"pointer"});if(!this.options.playpausefont)$pause.css({"background-image":'url("'+this.options.playpauseimage+'")',"background-repeat":"no-repeat","background-position":"right top"});else $pause.addClass("mhicon-pause").css({"text-align":"center","line-height":this.options.playpauseimageheight+"px","font-size":this.options.playpausefontsize+"px",color:this.options.playpausefontcolor,"background-color":this.options.playpausefontbgcolor,"border-radius":this.options.playpausefontcircle?"100%":
this.options.playpausefontradius+"px"});if(!isTouch||!this.options.disablehoverontouch)$pause.hover(function(){if(!instance.options.playpausefont)$(this).css({"background-position":"right bottom"});else $(this).css({color:instance.options.playpausefonthovercolor,"background-color":instance.options.playpausefonthoverbgcolor})},function(){if(!instance.options.playpausefont)$(this).css({"background-position":"right top"});else $(this).css({color:instance.options.playpausefontcolor,"background-color":instance.options.playpausefontbgcolor})});
$play.click(function(){if(instance.options.reloadstream)instance.amazingPlayer.reloadPlayAudio();else{if(instance.amazingPlayer.startEnabled)instance.amazingPlayer.playAudio(instance.amazingPlayer.startTime);else instance.amazingPlayer.playAudio();instance.amazingPlayer.startEnabled=false}});$pause.click(function(){if(instance.options.stoponpausebutton)instance.amazingPlayer.stopAudio();else instance.amazingPlayer.pauseAudio()});this.container.on("amazingaudioplayer.played",function(event,currentItem){$play.css({display:"none"});
$pause.css({display:"block"});if(instance.options.enablega&&instance.options.gatrackingid&&window.ga){ga("create",instance.options.gatrackingid,"auto","AmazingPlayerTracker");ga("AmazingPlayerTracker.send","event",instance.options.gacategory,"play",instance.amazingPlayer.elemArray[currentItem].title,instance.options.gaeventvalue)}if(instance.options.enablega4&&typeof window.gtag==="function")window.gtag("event","Audio",{"Action":"Play","Title":instance.amazingPlayer.elemArray[currentItem].title})});
this.container.on("amazingaudioplayer.paused",function(event,currentItem){$play.css({display:"block"});$pause.css({display:"none"});if(instance.options.enablega&&instance.options.gatrackingid&&window.ga){ga("create",instance.options.gatrackingid,"auto","AmazingPlayerTracker");ga("AmazingPlayerTracker.send","event",instance.options.gacategory,"pause",instance.amazingPlayer.elemArray[currentItem].title,instance.options.gaeventvalue)}if(instance.options.enablega4&&typeof window.gtag==="function")window.gtag("event",
"Audio",{"Action":"Pause","Title":instance.amazingPlayer.elemArray[currentItem].title})});this.container.on("amazingaudioplayer.stopped",function(event,currentItem){$play.css({display:"block"});$pause.css({display:"none"});if(instance.options.enablega&&instance.options.gatrackingid&&window.ga){ga("create",instance.options.gatrackingid,"auto","AmazingPlayerTracker");ga("AmazingPlayerTracker.send","event",instance.options.gacategory,"stop",instance.amazingPlayer.elemArray[currentItem].title,instance.options.gaeventvalue)}if(instance.options.enablega4&&
typeof window.gtag==="function")window.gtag("event","Audio",{"Action":"Stop","Title":instance.amazingPlayer.elemArray[currentItem].title})});this.container.on("amazingaudioplayer.ended",function(event,currentItem){if(instance.options.enablega&&instance.options.gatrackingid&&window.ga){ga("create",instance.options.gatrackingid,"auto","AmazingPlayerTracker");ga("AmazingPlayerTracker.send","event",instance.options.gacategory,"end",instance.amazingPlayer.elemArray[currentItem].title,instance.options.gaeventvalue)}if(instance.options.enablega4&&
typeof window.gtag==="function")window.gtag("event","Audio",{"Action":"End","Title":instance.amazingPlayer.elemArray[currentItem].title})});if(this.options.showstop){var $stop=$("<div class='amazingaudioplayer-stop'></div>");$stop.appendTo($bar).css({display:"block",width:this.options.stopimagewidth,height:this.options.stopimageheight,"background-image":'url("'+this.options.stopimage+'")',"background-repeat":"no-repeat","background-position":"center top",cursor:"pointer"});if(!isTouch||!this.options.disablehoverontouch)$stop.hover(function(){$(this).css({"background-position":"center bottom"})},
function(){$(this).css({"background-position":"center top"})});$stop.click(function(){instance.amazingPlayer.stopAudio()})}if(this.options.showprevnext){var $prev=$("<div class='amazingaudioplayer-prev'></div>");$prev.appendTo($bar).css({display:"block",width:this.options.prevnextimagewidth,height:this.options.prevnextimageheight,cursor:"pointer"});if(!this.options.prevfont)$prev.css({"background-image":'url("'+this.options.prevnextimage+'")',"background-repeat":"no-repeat","background-position":"left top"});
else $prev.addClass("mhicon-prev").css({"text-align":"center","line-height":this.options.prevnextimageheight+"px","font-size":this.options.prevfontsize+"px",color:this.options.prevfontcolor,"background-color":this.options.prevfontbgcolor,"border-radius":this.options.prevfontcircle?"100%":this.options.prevfontradius+"px"});if(!isTouch||!this.options.disablehoverontouch)$prev.hover(function(){if(!instance.options.prevfont)$(this).css({"background-position":"left bottom"});else $(this).css({color:instance.options.prevfonthovercolor,
"background-color":instance.options.prevfonthoverbgcolor})},function(){if(!instance.options.prevfont)$(this).css({"background-position":"left top"});else $(this).css({color:instance.options.prevfontcolor,"background-color":instance.options.prevfontbgcolor})});var $next=$("<div class='amazingaudioplayer-next'></div>");$next.appendTo($bar).css({display:"block",width:this.options.prevnextimagewidth,height:this.options.prevnextimageheight,cursor:"pointer"});if(!this.options.nextfont)$next.css({"background-image":'url("'+
this.options.prevnextimage+'")',"background-repeat":"no-repeat","background-position":"right top"});else $next.addClass("mhicon-next").css({"text-align":"center","line-height":this.options.prevnextimageheight+"px","font-size":this.options.nextfontsize+"px",color:this.options.nextfontcolor,"background-color":this.options.nextfontbgcolor,"border-radius":this.options.nextfontcircle?"100%":this.options.nextfontradius+"px"});if(!isTouch||!this.options.disablehoverontouch)$next.hover(function(){if(!instance.options.nextfont)$(this).css({"background-position":"right bottom"});
else $(this).css({color:instance.options.nextfonthovercolor,"background-color":instance.options.nextfonthoverbgcolor})},function(){if(!instance.options.nextfont)$(this).css({"background-position":"right top"});else $(this).css({color:instance.options.nextfontcolor,"background-color":instance.options.nextfontbgcolor})});$prev.click(function(){instance.amazingPlayer.audioRun(-2,instance.amazingPlayer.audioPlayer.isPlaying)});$next.click(function(){instance.amazingPlayer.audioRun(-1,instance.amazingPlayer.audioPlayer.isPlaying)})}if(this.options.showloop){var $loop=
$("<div class='amazingaudioplayer-loop'></div>");var backgroundPosX=["left","center","right"];var loopIcon=["mhicon-noloop","mhicon-loop","mhicon-loopsingle"];$loop.appendTo($bar).css({display:"block",width:this.options.loopimagewidth,height:this.options.loopimageheight,cursor:"pointer"});if(!this.options.loopfont)$loop.appendTo($bar).css({"background-image":'url("'+this.options.loopimage+'")',"background-repeat":"no-repeat","background-position":backgroundPosX[this.options.loop]+" top"});else $loop.addClass(loopIcon[this.options.loop]).css({"text-align":"center",
"line-height":this.options.loopimageheight+"px","font-size":this.options.loopfontsize+"px",color:this.options.loopfontcolor,"background-color":this.options.loopfontbgcolor,"border-radius":this.options.loopfontcircle?"100%":this.options.loopfontradius+"px"});if(!isTouch||!this.options.disablehoverontouch)$loop.hover(function(){if(!instance.options.loopfont){var backgroundPosX=$(this).css("background-position")?$(this).css("background-position").split(" ")[0]:$(this).css("background-position-x");$(this).css({"background-position":backgroundPosX+
" bottom"})}else $(this).css({color:instance.options.loopfonthovercolor,"background-color":instance.options.loopfonthoverbgcolor})},function(){if(!instance.options.loopfont){var backgroundPosX=$(this).css("background-position")?$(this).css("background-position").split(" ")[0]:$(this).css("background-position-x");$(this).css({"background-position":backgroundPosX+" top"})}else $(this).css({color:instance.options.loopfonthovercolor,"background-color":instance.options.loopfonthoverbgcolor})});$loop.click(function(){if(instance.options.loop>=
2)instance.options.loop=0;else instance.options.loop++;if(!instance.options.loopfont){var backgroundPosX=["left","center","right"];var backgroundPosY=$(this).css("background-position")?$(this).css("background-position").split(" ")[1]:$(this).css("background-position-y");$(this).css({"background-position":backgroundPosX[instance.options.loop]+" "+backgroundPosY});$(this).css({"background-position-x":backgroundPosX[instance.options.loop]});$(this).css({"background-position-y":backgroundPosY})}else{var loopIcon=
["mhicon-noloop","mhicon-loop","mhicon-loopsingle"];$(this).removeClass("mhicon-noloop").removeClass("mhicon-loop").removeClass("mhicon-loopsingle");$(this).addClass(loopIcon[instance.options.loop])}})}if(this.options.showtitleinbar){this.$bartitle=$("<div class='amazingaudioplayer-bar-title'></div>");this.$bartitle.appendTo($bar);this.$bartitle.css({display:"block",overflow:"hidden","white-space":"nowrap",width:this.options.titleinbarwidthmode=="auto"?"auto":this.options.titleinbarwidth,height:"auto"});
this.container.on("amazingaudioplayer.updateinfo",function(event,data){var duration=data.duration?formatSeconds(data.duration):"";var t=replaceMacro(instance.options.titleinbarformat,data,duration,instance.options.downloadbutton,instance.options.sharebutton);instance.$bartitletext=$("<span class='amazingaudioplayer-bar-title-text'>"+t+"</span>");instance.$bartitle.empty();instance.$bartitle.append(instance.$bartitletext);instance.$bartitle.css({"text-indent":0});instance.$bartitle.data("text-indent",
0);clearInterval(instance.updateTitleInBar);if(instance.options.titleinbarscroll){instance.bartitlewidth=instance.$bartitletext.width();instance.updateTitleInBar=setInterval(function(){var indent=instance.$bartitle.data("text-indent");indent--;if(indent<-instance.bartitlewidth)indent=instance.options.titleinbarwidth;instance.$bartitle.css({"text-indent":indent+"px"});instance.$bartitle.data("text-indent",indent)},1E3/25)}})}if(this.options.showinfoinbar){this.$barinfo=$("<div class='amazingaudioplayer-bar-info'></div>");
this.$barinfo.appendTo($bar);this.$barinfo.css({display:"block",overflow:"hidden","white-space":"nowrap",width:"auto",height:"auto"});this.container.on("amazingaudioplayer.updateinfo",function(event,data){var duration=data.duration?formatSeconds(data.duration):"";var t=replaceMacro(instance.options.infoinbarformat,data,duration,instance.options.downloadbutton,instance.options.sharebutton);instance.$barinfotext=$("<span class='amazingaudioplayer-bar-info-text'>"+t+"</span>");instance.$barinfo.empty();
instance.$barinfo.append(instance.$barinfotext);instance.$barinfo.css({"text-indent":0});instance.$barinfo.data("text-indent",0)})}if(this.options.showvolume&&!AmazingAudioPlatforms.isIOS()&&!AmazingAudioPlatforms.isAndroid()){this.$volume=$("<div class='amazingaudioplayer-volume'></div>");this.$volume.appendTo($bar);this.$volumeButton=$("<div class='amazingaudioplayer-volume-button'></div>");this.$volumeButton.appendTo(this.$volume);var changeVolumeButtonClass=function(instance,volume){if(!instance.options.volumefont){var backgroundPosY=
instance.$volumeButton.css("background-position")?instance.$volumeButton.css("background-position").split(" ")[1]:instance.$volumeButton.css("background-position-y");instance.$volumeButton.css({"background-position":(volume>0?"left":"right")+" "+backgroundPosY})}else if(volume>0)instance.$volumeButton.addClass("mhicon-volumeon").removeClass("mhicon-volumeoff");else instance.$volumeButton.addClass("mhicon-volumeoff").removeClass("mhicon-volumeon")};this.$volume.css({display:"block"});this.$volumeButton.css({display:"block",
position:"relative",width:this.options.volumeimagewidth,height:this.options.volumeimageheight,cursor:"pointer"});if(!this.options.volumefont)this.$volumeButton.css({"background-image":'url("'+this.options.volumeimage+'")',"background-repeat":"no-repeat","background-position":"left top"});else this.$volumeButton.addClass("mhicon-volumeon").css({"text-align":"center","line-height":this.options.volumeimageheight+"px","font-size":this.options.volumefontsize+"px",color:this.options.volumefontcolor,"background-color":this.options.volumefontbgcolor,
"border-radius":this.options.volumefontcircle?"100%":this.options.volumefontradius+"px"});if(!isTouch||!this.options.disablehoverontouch)this.$volumeButton.hover(function(){if(!instance.options.volumefont){var backgroundPosX=$(this).css("background-position")?$(this).css("background-position").split(" ")[0]:$(this).css("background-position-x");$(this).css({"background-position":backgroundPosX+" bottom"})}else $(this).css({color:instance.options.volumefonthovercolor,"background-color":instance.options.volumefonthoverbgcolor})},
function(){if(!instance.options.volumefont){var backgroundPosX=$(this).css("background-position")?$(this).css("background-position").split(" ")[0]:$(this).css("background-position-x");$(this).css({"background-position":backgroundPosX+" top"})}else $(this).css({color:instance.options.volumefontcolor,"background-color":instance.options.volumefontbgcolor})});this.$volumeButton.click(function(){var volume=instance.amazingPlayer.audioPlayer.getVolume();if(volume>0){instance.volumeSaved=volume;volume=0}else volume=
instance.volumeSaved;changeVolumeButtonClass(instance,volume);instance.amazingPlayer.audioPlayer.setVolume(volume);if(instance.options.showvolumebar)if(instance.options.volumebarposition=="top"||instance.options.volumebarposition=="bottom")instance.$volumeBarAdjustActive.css({height:Math.round(volume*100)+"%"});else instance.$volumeBarAdjustActive.css({width:Math.round(volume*100)+"%"})});if(this.options.showvolumebar){this.$volumeBar=$("<div class='amazingaudioplayer-volume-bar'></div>");this.$volumeBar.appendTo(this.$volume);
this.$volumeBarAdjust=$("<div class='amazingaudioplayer-volume-bar-adjust'></div>");this.$volumeBarAdjust.appendTo(this.$volumeBar);this.$volumeBarAdjustActive=$("<div class='amazingaudioplayer-volume-bar-adjust-active'></div>");this.$volumeBarAdjustActive.appendTo(this.$volumeBarAdjust);this.$volumeBar.css({display:"none",position:"absolute","-webkit-box-sizing":"content-box","-moz-box-sizing":"content-box","box-sizing":"content-box",padding:this.options.volumebarpadding,margin:"0 "+String((this.options.volumeimagewidth-
this.options.volumebarwidth)/2)+"px","z-index":1});switch(this.options.volumebarposition){case "bottom":this.$volumeBar.css({left:0,top:"100%",width:this.options.volumebarwidth-2*this.options.volumebarpadding,height:this.options.volumebarheight-2*this.options.volumebarpadding});break;case "left":this.$volumeBar.css({right:"100%",top:0,height:this.options.volumebarwidth-2*this.options.volumebarpadding,width:this.options.volumebarheight-2*this.options.volumebarpadding});break;case "right":this.$volumeBar.css({left:"100%",
top:0,height:this.options.volumebarwidth-2*this.options.volumebarpadding,width:this.options.volumebarheight-2*this.options.volumebarpadding});break;case "top":this.$volumeBar.css({left:0,bottom:"100%",width:this.options.volumebarwidth-2*this.options.volumebarpadding,height:this.options.volumebarheight-2*this.options.volumebarpadding});break}this.$volumeBarAdjust.css({display:"block",position:"relative",width:"100%",height:"100%",cursor:"pointer"});this.$volumeBarAdjustActive.css({display:"block",
position:"absolute",left:0,bottom:0,width:"100%",height:"100%"});var adjustVolumeBar=function(e){var e0=isTouch&&e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0?e.originalEvent.touches[0]:e;var vol;if(instance.options.volumebarposition=="top"||instance.options.volumebarposition=="bottom"){vol=1-(e0.pageY-instance.$volumeBarAdjust.offset().top)/instance.$volumeBarAdjust.height();vol=vol>1?1:vol<0?0:vol;instance.$volumeBarAdjustActive.css({height:Math.round(vol*100)+"%"})}else{vol=
(e0.pageX-instance.$volumeBarAdjust.offset().left)/instance.$volumeBarAdjust.width();vol=vol>1?1:vol<0?0:vol;instance.$volumeBarAdjustActive.css({width:Math.round(vol*100)+"%"})}changeVolumeButtonClass(instance,vol);instance.amazingPlayer.audioPlayer.setVolume(vol)};this.$volumeBarAdjust.on(eStart,function(e){adjustVolumeBar(e);instance.$volumeBarAdjust.on(eMove,function(e){adjustVolumeBar(e)})}).on(eCancel,function(){instance.$volumeBarAdjust.off(eMove)});this.hideVolumeBarTimeout=null;if(!isTouch||
!instance.options.disablehoverontouch)this.$volume.hover(function(){clearTimeout(instance.hideVolumeBarTimeout);if(AmazingAudioPlatforms.isIE678())instance.$volumeBar.show();else instance.$volumeBar.fadeIn()},function(){clearTimeout(instance.hideVolumeBarTimeout);instance.hideVolumeBarTimeout=setTimeout(function(){if(AmazingAudioPlatforms.isIE678())instance.$volumeBar.hide();else instance.$volumeBar.fadeOut()},1E3)})}this.container.on("amazingaudioplayer.setvolume",function(event,volume){volume=volume>
1?1:volume<0?0:volume;changeVolumeButtonClass(instance,volume);if(instance.options.showvolumebar)if(instance.options.volumebarposition=="top"||instance.options.volumebarposition=="bottom")instance.$volumeBarAdjustActive.css({height:Math.round(volume*100)+"%"});else instance.$volumeBarAdjustActive.css({width:Math.round(volume*100)+"%"})})}if(this.options.showtime){var $time=$("<div class='amazingaudioplayer-time'></div>");$time.appendTo($bar);this.container.on("amazingaudioplayer.playprogress",function(event,
data){var current=isNaN(data.current)?0:data.current;var duration=isNaN(data.duration)||!isFinite(data.duration)?0:data.duration;var left=formatSeconds((duration-current)/1E3);current=formatSeconds(current/1E3);duration=formatSeconds(duration/1E3);var t;if(data.live)t=instance.options.timeformatlive.replace("%CURRENT%",current);else t=instance.options.timeformat.replace("%CURRENT%",current).replace("%DURATION%",duration).replace("%LEFT%",left);$time.html(t)});this.container.on("amazingaudioplayer.played",
function(event,currentItem){if(instance.options.showloading)$time.html(instance.options.loadingformat)})}if(this.options.showprogress){var $progress=$("<div class='amazingaudioplayer-progress'></div>");var $progressLoaded=$("<div class='amazingaudioplayer-progress-loaded'></div>");var $progressPlayed=$("<div class='amazingaudioplayer-progress-played'></div>");$progressLoaded.appendTo($progress);$progressPlayed.appendTo($progress);if(instance.options.progressinbar)$progress.appendTo($bar);else $progress.appendTo(this.playerwrapper);
$progress.css({display:"block",cursor:"pointer",overflow:"hidden",height:this.options.progressheight});if($progress.css("right")=="auto")$progress.css("right",$progress.css("left"));$progressLoaded.css({display:"block",position:"absolute",left:0,top:0,height:"100%"});$progressPlayed.css({display:"block",position:"absolute",left:0,top:0,height:"100%"});$progress.on(eStart,function(e){var e0=isTouch&&e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0?e.originalEvent.touches[0]:
e;var pageoffset=e0.pageX-$progress.offset().left;if(navigator.userAgent.match(/Android/i)!=null)pageoffset+=$(window).scrollLeft();var pos=pageoffset/$progress.width();instance.amazingPlayer.setTime(pos);$progress.on(eMove,function(e){var e0=isTouch&&e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0?e.originalEvent.touches[0]:e;var pageoffset=e0.pageX-$progress.offset().left;if(navigator.userAgent.match(/Android/i)!=null)pageoffset+=$(window).scrollLeft();var pos=pageoffset/
$progress.width();instance.amazingPlayer.setTime(pos)})}).on(eCancel,function(){$progress.off(eMove)});this.container.on("amazingaudioplayer.loadprogress",function(event,progress){$progressLoaded.css({width:progress+"%"})});this.container.on("amazingaudioplayer.playprogress",function(event,data){if(data.live)return;var progress=0;if(!isNaN(data.duration)&&isFinite(data.duration)&&data.duration>0)progress=Math.ceil(data.current*100/data.duration);$progressPlayed.css({width:progress+"%"})})}$bar.append("<div class='amazingaudioplayer-bar-buttons-clear'></div>");
if(this.options.showtracklist){if(this.options.showtracklistsearch){this.$tracklistsearch=$("<div class='amazingaudioplayer-tracklistsearch'><input type='text' class='amazingaudioplayer-tracklistsearch-input' value='' placeholder='"+this.options.searchplaceholder+"'></div>");this.$tracklistsearch.appendTo(this.container);this.$tracklistsearch.css({display:"block",position:"relative",height:"auto"});$(".amazingaudioplayer-tracklistsearch-input",this.$tracklistsearch).on("keyup",function(e){var searchtext=
String($.trim($(this).val())).toLowerCase();var visibleCount=0;for(var i=0;i<instance.amazingPlayer.elemLength;i++){var data=instance.amazingPlayer.elemArray[i];var match=data.title&&data.title.toLowerCase().indexOf(searchtext)>=0;if(!instance.options.searchtitleonly)match=match||data.album&&data.album.toLowerCase().indexOf(searchtext)>=0||data.artist&&data.artist.toLowerCase().indexOf(searchtext)>=0||data.info&&data.info.toLowerCase().indexOf(searchtext)>=0||data.id&&String(data.id).indexOf(searchtext)>=
0;if(match)visibleCount++;$(".amazingaudioplayer-track-item",instance.container).eq(i).css({display:match?"block":"none"})}if(instance.options.tracklistitem<instance.amazingPlayer.elemLength)if(instance.options.tracklistscroll){$.amascrollbar_clear(instance.$tracklist,instance.$tracks);if(instance.options.tracklistitem<visibleCount)$.amascrollbar(instance.$tracklist,instance.$tracks,{barwidth:instance.options.tracklistbarwidth,barbgcolor:instance.options.tracklistbarbgcolor,thumbcolor:instance.options.tracklistthumbcolor,
thumbopacity:instance.options.tracklistthumbopacity,enablepagescroll:instance.options.tracklistenablepagescroll})}else{instance.clearNavArrows();if(instance.options.tracklistitem<visibleCount)instance.drawNavArrows()}})}this.$tracklistwrapper=$("<div class='amazingaudioplayer-tracklist'></div>");this.$tracklistwrapper.appendTo(this.container);this.$tracklistwrapper.css({display:"block",height:"auto"});this.$tracklistcontainer=$("<div class='amazingaudioplayer-tracklist-container'></div>");this.$tracklistcontainer.appendTo(this.$tracklistwrapper);
if(this.options.showtracklistbackgroundimage)this.$tracklistcontainer.css({"background-image":'url("'+this.options.tracklistbackgroundimage+'")'});this.$tracklist=$("<div class='amazingaudioplayer-tracks-wrapper'></div>");this.$tracklist.appendTo(this.$tracklistcontainer);this.$tracks=$("<ul class='amazingaudioplayer-tracks'></ul>");this.$tracks.appendTo(this.$tracklist);this.$tracks.css({display:"block"});this.container.on("amazingaudioplayer.switched",function(event,data){if(data.previous>=0){instance.trackitems[data.previous].removeClass("amazingaudioplayer-track-item-active");
instance.trackitems[data.previous].removeClass("amazingaudioplayer-track-item-hoverover")}if(data.current>=0){instance.trackitems[data.current].addClass("amazingaudioplayer-track-item-active");instance.trackitems[data.current].removeClass("amazingaudioplayer-track-item-hoverover");if(!instance.options.tracklistscroll&&instance.options.tracklistitem<instance.amazingPlayer.elemLength){var page=Math.floor(data.current/instance.options.tracklistitem);if(instance.tracklistPage!=page){instance.tracklistPage=
page;if(instance.tracklistPage==0){instance.$tracklistarrowprev.hide();instance.$tracklistarrownext.show()}else if(instance.tracklistPage==instance.tracklistPageNum-1){instance.$tracklistarrowprev.show();instance.$tracklistarrownext.hide()}else{instance.$tracklistarrowprev.show();instance.$tracklistarrownext.show()}var t=-instance.tracklistPage*instance.tracklistItemHeight*instance.options.tracklistitem;instance.$tracks.animate({top:t})}}}});this.tracklistItemHeight=0;this.trackitems=new Array;for(var i=
0;i<this.amazingPlayer.elemLength;i++){var $track=$("<li class='amazingaudioplayer-track-item' data-trackid="+i+"></li>");var data=this.amazingPlayer.elemArray[i];var duration=data.duration?formatSeconds(data.duration):data.live?this.options.livetitle:"";var title=data.title;if(!title&&this.options.changeemptytitletospace)title="&nbsp;";var t=replaceMacro(instance.options.tracklistitemformat,data,duration,instance.options.downloadbutton,instance.options.sharebutton);$track.data("order",i);$track.html(t);
$track.appendTo(this.$tracks);this.tracklistItemHeight=$track.outerHeight(true);this.trackitems.push($track);$track.click(function(){instance.amazingPlayer.audioRun($(this).data("order"),true)});if(!isTouch||!instance.options.disablehoverontouch)$track.hover(function(){$(this).addClass("amazingaudioplayer-track-item-active");if($(this).data("order")!=instance.amazingPlayer.currentItem)$(this).addClass("amazingaudioplayer-track-item-hoverover")},function(){if($(this).data("order")!=instance.amazingPlayer.currentItem)$(this).removeClass("amazingaudioplayer-track-item-active");
$(this).removeClass("amazingaudioplayer-track-item-hoverover")});if(this.tracklistItemHeight<=0){var $trackclone=$track.clone();$trackclone.css({position:"absolute",visibility:"hidden",display:"block"}).appendTo("body");this.tracklistItemHeight=$trackclone.outerHeight(true);$trackclone.remove()}}this.$tracklist.css({overflow:"hidden"});this.clearNavArrows=function(){$(".amazingaudioplayer-tracklist-arrow-prev",this.$tracklistwrapper).remove();$(".amazingaudioplayer-tracklist-arrow-next",this.$tracklistwrapper).remove();
$(".amazingaudioplayer-tracks",this.$tracklistwrapper).css({top:0})};this.drawNavArrows=function(){this.tracklistPage=0;this.tracklistPageNum=Math.ceil(this.amazingPlayer.elemLength/this.options.tracklistitem);this.$tracklistarrowprev=$("<div class='amazingaudioplayer-tracklist-arrow-prev'></div>");this.$tracklistarrowprev.appendTo(this.$tracklistwrapper);this.$tracklistarrowprev.css({display:"none",width:this.options.tracklistarrowimagewidth,height:this.options.tracklistarrowimageheight,"background-image":'url("'+
this.options.tracklistarrowimage+'")',"background-repeat":"no-repeat","background-position":"left top",cursor:"pointer"});if(!isTouch||!this.options.disablehoverontouch)this.$tracklistarrowprev.hover(function(){$(this).css({"background-position":"left bottom"})},function(){$(this).css({"background-position":"left top"})});this.$tracklistarrownext=$("<div class='amazingaudioplayer-tracklist-arrow-next'></div>");this.$tracklistarrownext.appendTo(this.$tracklistwrapper);this.$tracklistarrownext.css({display:"block",
width:this.options.tracklistarrowimagewidth,height:this.options.tracklistarrowimageheight,"background-image":'url("'+this.options.tracklistarrowimage+'")',"background-repeat":"no-repeat","background-position":"right top",cursor:"pointer"});if(!isTouch||!this.options.disablehoverontouch)this.$tracklistarrownext.hover(function(){$(this).css({"background-position":"right bottom"})},function(){$(this).css({"background-position":"right top"})});this.$tracklistarrowprev.click(function(){instance.tracklistPage--;
if(instance.tracklistPage<=0){instance.tracklistPage=0;instance.$tracklistarrowprev.hide()}instance.$tracklistarrownext.show();var t=-instance.tracklistPage*instance.tracklistItemHeight*instance.options.tracklistitem;instance.$tracks.animate({top:t})});this.$tracklistarrownext.click(function(){instance.tracklistPage++;if(instance.tracklistPage>=instance.tracklistPageNum-1){instance.tracklistPage=instance.tracklistPageNum-1;instance.$tracklistarrownext.hide()}instance.$tracklistarrowprev.show();var t=
-instance.tracklistPage*instance.tracklistItemHeight*instance.options.tracklistitem;instance.$tracks.animate({top:t})})};if(this.options.tracklistitem<this.amazingPlayer.elemLength){this.$tracklist.css({height:this.tracklistItemHeight*this.options.tracklistitem+"px"});if(this.options.tracklistscroll){this.$tracklist.css({"padding-right":this.options.tracklistpadding+"px"});$.amascrollbar(this.$tracklist,this.$tracks,{barwidth:this.options.tracklistbarwidth,barbgcolor:this.options.tracklistbarbgcolor,
thumbcolor:this.options.tracklistthumbcolor,thumbopacity:this.options.tracklistthumbopacity,enablepagescroll:this.options.tracklistenablepagescroll})}else this.drawNavArrows()}this.container.append("<div class='amazingaudioplayer-tracklist-clear'></div>")}if(this.options.showliveplayedlist){this.playedlistwrapper=$("<div class='amazingaudioplayer-playedlist-wrapper'></div>");this.playedlistwrapper.appendTo(this.container)}if(this.options.addwm&&window.location.href.indexOf(this.options.fvm)<0){var $wm=
$("<div style='display:block !important;visibility:visible !important;position:absolute;top:100%;right:0;margin:4px;text-align:right;font:normal 10px Arial, sans-serif;'><a href='"+this.options.lvm+"' target='_blank' style='color:#666;text-decoration:none;' class='amazingaudioplayer-mark'>"+this.options.pvm+"</a></div>");$wm.appendTo(this.container)}};var AmazingHTML5Player=function(amazingPlayer){this.amazingPlayer=amazingPlayer;this.container=this.amazingPlayer.container;this.id=this.amazingPlayer.id;
this.html5Object=null;this.isHtml5=false;this.isVideo=false;this.isPlaying=false;this.html5LoadUpdate=null;this.audioItem=null;var a=document.createElement("audio");this.supportMp3=!!(a.canPlayType&&a.canPlayType("audio/mpeg;").replace(/no/,""));this.supportOgg=!!(a.canPlayType&&a.canPlayType('audio/ogg; codecs="vorbis"').replace(/no/,""))};AmazingHTML5Player.prototype={resetHtml5:function(){if($("#amazingaudioobject-"+this.id,this.container).length>0&&$("#amazingaudioobject-"+this.id,this.container).get(0))$("#amazingaudioobject-"+
this.id,this.container).get(0).src="";$("#amazingaudioobject-"+this.id,this.container).remove();this.html5Object=null;if(this.html5LoadUpdate){clearInterval(this.html5LoadUpdate);this.html5LoadUpdate=null}},initHtml5:function(){var objectType=this.isVideo?"video":"audio";var html5Object=$("<"+objectType+" id='amazingaudioobject-"+this.id+"'"+(this.isVideo?" playsinline":"")+" preload='"+(this.amazingPlayer.options.preloadaudio?"auto":"none")+"' style='display:none;'></"+objectType+">");html5Object.appendTo(this.container);
var html5Audio=html5Object.get(0);var instance=this;html5Audio.addEventListener("ended",function(){instance.amazingPlayer.onAudioEnded()});html5Audio.addEventListener("timeupdate",function(){instance.amazingPlayer.playProgress(html5Audio.currentTime*1E3,html5Audio.duration*1E3)});html5Audio.addEventListener("durationchange",function(){if(instance.isPlaying)html5Audio.play()});return html5Object},load:function(audioItem){this.audioItem=audioItem;var audioSource=audioItem.source;var i;this.isHtml5=
true;for(i=0;i<audioSource.length;i++)if(audioSource[i].type=="video/mp4"){this.isVideo=true;break}if(this.isHtml5){this.resetHtml5();this.html5Object=this.initHtml5();this.html5Object.get(0).pause();this.html5Object.empty();this.html5Object.currentTime=0;this.amazingPlayer.playProgress(0,0);if(this.audioItem.title)this.html5Object.attr("title",this.audioItem.title);for(i=0;i<audioSource.length;i++)if(audioSource[i].type=="audio/mpeg"&&this.supportMp3||audioSource[i].type=="audio/ogg"&&this.supportOgg||
audioSource[i].type=="video/mp4")this.html5Object.append("<source src='"+audioSource[i].src+"' type='"+audioSource[i].type+"'></source>");this.amazingPlayer.playProgress(0,0);this.html5AudioLoaded=false;if(this.amazingPlayer.options.preloadaudio)this.html5LoadAudio()}},html5LoadAudio:function(){this.html5AudioLoaded=true;this.html5Object.get(0).load();var html5Audio=this.html5Object.get(0);var instance=this;this.html5LoadUpdate=setInterval(function(){if(html5Audio.buffered&&html5Audio.buffered.length>
0&&!isNaN(html5Audio.buffered.end(0))&&!isNaN(html5Audio.duration)){var percent=Math.ceil(html5Audio.buffered.end(0)*100/html5Audio.duration);instance.amazingPlayer.loadProgress(percent);if(percent>=100){clearInterval(instance.html5LoadUpdate);instance.html5LoadUpdate=null}instance.amazingPlayer.playProgress(html5Audio.currentTime*1E3,html5Audio.duration*1E3)}},100)},play:function(startTime,duration){var instance=this;if(this.isHtml5){if(!this.html5AudioLoaded)this.html5LoadAudio();if(startTime>0&&
(AmazingAudioPlatforms.isIOS()||AmazingAudioPlatforms.isSafari()))this.html5Object.one("play",function(){instance.html5Object.get(0).currentTime=startTime});var promise=this.html5Object.get(0).play();if(promise!==undefined&&"catch"in promise)promise["catch"](function(){instance.amazingPlayer.pauseAudio()});if(startTime>0)this.html5Object.get(0).currentTime=startTime;this.setPlaybackRate(this.amazingPlayer.options.playbackrate);if(AmazingAudioPlatforms.isIE()){var instance=this;setTimeout(function(){instance.setPlaybackRate(instance.amazingPlayer.options.playbackrate)},
100)}}this.isPlaying=true},getMp3Src:function(){var audioSource=this.audioItem.source;var mp3Src="";for(var i=0;i<audioSource.length;i++)if(audioSource[i].type=="audio/mpeg")mp3Src=audioSource[i].src;return mp3Src},pause:function(){if(this.isHtml5)this.html5Object.get(0).pause();this.isPlaying=false},stop:function(){if(this.isHtml5){this.html5Object.get(0).pause();this.html5Object.get(0).currentTime=0}this.isPlaying=false},setTime:function(pos,duration){if(this.isHtml5)if(!isNaN(this.html5Object.get(0).duration)&&
isFinite(this.html5Object.get(0).duration)&&this.html5Object.get(0).duration>0)this.html5Object.get(0).currentTime=this.html5Object.get(0).duration*pos;else this.html5Object.get(0).currentTime=duration*pos},getDuration:function(){return this.isHtml5?this.html5Object.get(0).duration:0},getSeconds:function(){return this.isHtml5?this.html5Object.get(0).currentTime:0},setSeconds:function(seconds){if(this.isHtml5)this.html5Object.get(0).currentTime=seconds},getVolume:function(){if(this.isHtml5)return this.html5Object.get(0).volume},
setVolume:function(val){if(this.isHtml5)this.html5Object.get(0).volume=val},setPlaybackRate:function(val){if(this.isHtml5)this.html5Object.get(0).playbackRate=val}};var AmazingAudioPlayer=function(container,options,id){this.container=container;this.options=options;this.id=id;$(".amazingaudioplayer-engine").css({display:"none"});this.currentItem=-1;this.elemArray=new Array;this.elemLength=0;this.liveUpdateTimeout=null;this.liveTracklist=new Array;this.audioPlayer=new AmazingHTML5Player(this)};AmazingAudioPlayer.prototype=
{initPlayer:function(){this.initData(this.init)},initData:function(onSuccess){this.readTags();if(this.options.remote&&this.options.remote.length>0)this.readRemote(onSuccess);else if(this.options.wptracklist)this.readWpTracklist(onSuccess);else onSuccess(this)},changeurltohttp:function(url){if(url&&url.length>0)if(url.toLowerCase().indexOf("https://")==0)url="http://"+url.substr(8);return url},readTags:function(){var instance=this;$("ul.amazingaudioplayer-audios",this.container).find("li").each(function(){var $this=
$(this);var audioSource=new Array;$this.find("div.amazingaudioplayer-source").each(function(){audioSource.push({src:$(this).data("src"),type:$(this).data("type").toLowerCase()})});if(instance.options.forceurltohttp)for(var i=0;i<audioSource.length;i++)audioSource[i].src=instance.changeurltohttp(audioSource[i].src);var audioId=instance.elemArray.length+1;instance.elemArray.push({id:audioId,source:audioSource,title:$this.data("title")?$this.data("title"):"",artist:$this.data("artist")?$this.data("artist"):
"",album:$this.data("album")?$this.data("album"):"",info:$this.data("info")?$this.data("info"):"",duration:$this.data("duration")?$this.data("duration"):"",image:$this.data("image")&&$this.data("image").length>0?$this.data("image"):"",radionomyradiouid:$this.data("radionomyradiouid")?$this.data("radionomyradiouid"):"",icecast2status:$this.data("icecast2status")?$this.data("icecast2status"):"",live:$this.data("live")?true:false})})},readWpTracklist:function(onSuccess){var instance=this;if(typeof wonderplugin_audio_ajaxobject!=
"undefined"){var args={type:"POST",data:{action:"wonderplugin_audio_gettracklist",playerid:instance.id,nonce:wonderplugin_audio_ajaxobject.nonce},url:wonderplugin_audio_ajaxobject.ajaxurl};$.ajax(args).done(function(data){if(data&&$.isArray(data)&&data.length>0){for(var i=0;i<data.length;i++){var audioId=instance.elemArray.length+1;var audioSource=new Array;if(data[i].mp3)audioSource.push({src:data[i].mp3,type:"audio/mpeg"});if(data[i].ogg)audioSource.push({src:data[i].ogg,type:"audio/ogg"});instance.elemArray.push({id:audioId,
source:audioSource,title:data[i].title?data[i].title:"",artist:data[i].artist?data[i].artist:"",album:data[i].album?data[i].album:"",info:data[i].info?data[i].info:"",duration:data[i].duration?data[i].duration:"",image:data[i].image?data[i].image:"",radionomyradiouid:data[i].radionomyradiouid?data[i].radionomyradiouid:"",icecast2status:data[i].icecast2status?data[i].icecast2status:"",live:data[i].live==="true"||data[i].live===true?true:false})}onSuccess(instance)}})}},readRemote:function(onSuccess){var instance=
this;$.getJSON(instance.options.remote,function(data){for(var i=0;i<data.length;i++)if(data[i].source){var audioSource=new Array;for(var j=0;j<data[i].source.length;j++)audioSource.push({src:data[i].source[j].src,type:data[i].source[j].type});if(instance.options.forceurltohttp)for(var i=0;i<audioSource.length;i++)audioSource[i].src=instance.changeurltohttp(audioSource[i].src);var audioId=instance.elemArray.length+1;instance.elemArray.push({id:audioId,source:audioSource,title:data[i].title?data[i].title:
"",artist:data[i].artist?data[i].artist:"",album:data[i].album?data[i].album:"",info:data[i].info?data[i].info:"",duration:data[i].duration?data[i].duration:"",image:data[i].image?data[i].image:"",radionomyradiouid:data[i].radionomyradiouid?data[i].radionomyradiouid:"",icecast2status:data[i].icecast2status?data[i].icecast2status:"",live:data[i].live?true:false})}onSuccess(instance)})},init:function(instance){instance.container.trigger("amazingaudioplayer.initstarted",instance.id);$(window).trigger("amazingaudioplayer.initstarted",
instance.id);instance.processInit();instance.container.trigger("amazingaudioplayer.initfinished",instance.id);$(window).trigger("amazingaudioplayer.initfinished",instance.id)},enableTabIndex:function(){$(".amazingaudioplayer-play, .amazingaudioplayer-pause, .amazingaudioplayer-prev, .amazingaudioplayer-next, .amazingaudioplayer-loop, .amazingaudioplayer-volume-button",this.container).attr("tabindex","0").keyup(function(e){if(e.keyCode==13)$(this).trigger("click")})},processInit:function(){var instance=
this;var i;instance.elemLength=instance.elemArray.length;if(instance.elemLength<=0)return;if(instance.elemLength>instance.options.maxlen&&instance.options.addwm&&window.location.href.indexOf(instance.options.fvm)<0){instance.elemLength=instance.options.maxlen;instance.elemArray.length=instance.options.maxlen}if(instance.options.random){for(i=instance.elemLength-1;i>0;i--){if(i==1&&Math.random()<.5)break;var index=Math.floor(Math.random()*i);var temp=instance.elemArray[index];instance.elemArray[index]=
instance.elemArray[i];instance.elemArray[i]=temp}for(i=0;i<instance.elemLength;i++)instance.elemArray[i].id=i+1}if(instance.options.enablega&&instance.options.gatrackingid&&!window.ga){(function(i,s,o,g,r,a,m){i["GoogleAnalyticsObject"]=r;i[r]=i[r]||function(){(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date;a=s.createElement(o),m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)})(window,document,"script","https://www.google-analytics.com/analytics.js","ga");ga("create",
instance.options.gatrackingid,"auto","AmazingPlayerTracker")}if(instance.options.enablega4&&instance.options.ga4account&&typeof window.gtag!=="function"){window.dataLayer=window.dataLayer||[];window.gtag=function(){dataLayer.push(arguments)};window.gtag("js",new Date);window.gtag("config",instance.options.ga4account);$.getScript("https://www.googletagmanager.com/gtag/js?id="+encodeURIComponent(instance.options.ga4account))}instance.isPlaying=false;instance.loopCount=0;instance.createSkin();if(instance.options.saveposincookie)instance.container.on("amazingaudioplayer.playprogress",
function(event,data){var current=isNaN(data.current)?0:data.current;$.amaudioCookie("amaudiopos-"+instance.id,instance.currentItem+"-"+String(current),{expires:instance.options.cookiehours*60*60})});var params=instance.getParams();var firstId=0;instance.startTime=0;instance.startEnabled=false;instance.endTime=0;instance.endAudioId=-1;instance.endEnabled=false;if(instance.options.saveposincookie)if($.amaudioCookie("amaudiopos-"+instance.id)){var savedpos=$.amaudioCookie("amaudiopos-"+instance.id).split("-");
if(savedpos&&savedpos.length==2){firstId=parseInt(savedpos[0]);instance.startTime=parseFloat(savedpos[1])/1E3}}if("audioid"+instance.id in params&&!isNaN(params["audioid"+instance.id])&&params["audioid"+instance.id]>=0&&params["audioid"+instance.id]<instance.elemLength)firstId=parseInt(params["audioid"+instance.id]);if(!("playerid"in params)||!isNaN(params["playerid"])&&params["playerid"]==instance.id){if("firstaudioid"in params&&!isNaN(params["firstaudioid"])&&params["firstaudioid"]>=0&&params["firstaudioid"]<
instance.elemLength)firstId=parseInt(params["firstaudioid"]);else if("audioid"in params&&!isNaN(params["audioid"])&&params["audioid"]>=0&&params["audioid"]<instance.elemLength)firstId=parseInt(params["audioid"]);instance.audioRun(firstId,false);if("autoplayaudio"in params)if(params["autoplayaudio"]=="1")instance.options.autoplay=true;else if(params["autoplayaudio"]=="0")instance.options.autoplay=false;if("start"in params&&!isNaN(params["start"])&&params["start"]>=0)instance.startTime=parseInt(params["start"]);
if("end"in params&&!isNaN(params["end"])&&params["end"]>=0){instance.endTime=parseInt(params["end"]);instance.endAudioId=firstId;instance.endEnabled=true;instance.container.on("amazingaudioplayer.playprogress",function(event,data){if(instance.endEnabled&&instance.endAudioId==instance.currentItem)if(data.current>=instance.endTime*1E3){instance.endEnabled=false;if(instance.audioPlayer.isPlaying)instance.pauseAudio()}})}if("playerview"in params&&params["playerview"]=="1")setTimeout(function(){instance.container.get(0).scrollIntoView()},
instance.options.playerviewdelay)}if(instance.startTime>0)instance.startEnabled=true;if(instance.options.autoplay&&!AmazingAudioPlatforms.autoplayDisabled())window.setTimeout(function(){instance.playAudio(instance.startTime);instance.startEnabled=false},instance.options.autoplaytimeout);else if(instance.currentItem>=0&&instance.startTime>0&&instance.startTime<instance.elemArray[instance.currentItem].duration)instance.setTime(instance.startTime/instance.elemArray[instance.currentItem].duration);if(instance.options.defaultvolume>=
0)instance.setVolume(instance.options.defaultvolume/100);instance.container.on("amazingaudioplayer.stop",function(event,id){if(id!=instance.id&&instance.audioPlayer.isPlaying)instance.pauseAudio()});instance.initSocial();var divId=instance.id;if(divId==0){var conId=instance.container.attr("id");if(conId){conId=conId.split("-");if(conId.length==2&&!isNaN(conId[1]))divId=parseInt(conId[1])}}if(divId>0)if($(".amazingaudioplayer-shuffle-"+divId).length>0)$(".amazingaudioplayer-shuffle-"+divId).click(function(){instance.shuffle()});
if(instance.options.enabletabindex)instance.enableTabIndex()},shuffle:function(){var instance=this;for(var i=instance.elemLength-1;i>0;i--){if(i==1&&Math.random()<.5)break;var index=Math.floor(Math.random()*i);var temp=instance.elemArray[index];instance.elemArray[index]=instance.elemArray[i];instance.elemArray[i]=temp}for(i=0;i<instance.elemLength;i++)instance.elemArray[i].id=i+1;$(".amazingaudioplayer-player-wrapper, .amazingaudioplayer-tracklist, .amazingaudioplayer-tracklist-clear, audio",this.container).remove();
instance.createSkin();instance.audioRun(0,false)},initSocial:function(){var instance=this;$(".amazingaudioplayer-tracks .wonderaudio-share",this.container).click(function(e){e.stopPropagation();var trackId=instance.currentItem;var trackItem=$(this).closest(".amazingaudioplayer-track-item");if(trackItem.length>0)trackId=trackItem.data("trackid");instance.showSocial(trackId)});$(document).on("click",".amazingaudioplayer-player-wrapper .wonderaudio-share",function(e){instance.showSocial(instance.currentItem)})},
showSocial:function(trackId){var title=replaceMacro(this.options.titleformat,this.elemArray[trackId],"","","");var info=replaceMacro(this.options.infoformat,this.elemArray[trackId],"","","");var shareTitle=replaceMacro(this.options.sharetitleformat,this.elemArray[trackId],"","","");if(!shareTitle)shareTitle=this.options.defaultsharetitle;var shareMedia=this.elemArray[trackId].image;var shareUrl;if(this.options.shareaudiourl)shareUrl=this.elemArray[this.currentItem].source[0].src;else{var params=this.getParams();
params.playerid=this.id;params.audioid=trackId;params.playerview=1;shareUrl=window.location.href.split("?")[0]+"?";var i=0;for(var param in params){shareUrl+=(i>0?"&":"")+param+"="+params[param];i++}}$("#wonderaudio-lightbox").remove();var socialDialog=$("<div id='wonderaudio-lightbox' style='display:block;position:fixed;top:0px;left:0px;width:100%;height:100%;z-index:9999998;text-align:center;'>"+'<div class="wonderaudio-lightbox-overlay" style="position:absolute;top:0;left:0;width:100%;height:100%;background-color:rgba(0,0,0,0.6);"></div>'+
'<div class="wonderaudio-lightbox-social" style="display:block;position:relative;top:50%;transform: translateY(-50%);margin:32px auto;padding:24px;width:480px;height:auto;background-color:#ffffff;max-width:96%;box-sizing:border-box;">'+'<div class="mhicon-cancel wonderaudio-lightbox-close" style="display:block;cursor:pointer;position:absolute;top:0;right:0;width:30px;height:30px;line-height:30px;font-size:20px;text-align:center;margin:0;color:#444;"></div>'+'<div class="wonderaudio-lightbox-head" style="position:relative;font-weight:bold;font-size:24px;text-align:left;margin:8px 0 16px;">Share</div>'+
(title?'<div class="wonderaudio-lightbox-title" style="position:relative;font-weight:bold;font-size:18px;text-align:left;margin:8px 0;">'+title+"</div>":"")+(info?'<div class="wonderaudio-lightbox-info" style="position:relative;font-size:16px;text-align:left;margin:8px 0;">'+info+"</div>":"")+'<div class="wonderaudio-lightbox-toolbar" style="position:relative;text-align:left;padding:8px 0;">'+'<a target="_blank" class="wonderaudio-button-link" href="https://www.facebook.com/sharer/sharer.php?u='+
encodeURIComponent(shareUrl)+"&t="+encodeURIComponent(shareTitle)+'"><div class="mhicon-facebook" style="cursor:pointer;display:inline-block;margin:0 12px 0 0;width:32px;height:32px;line-height:32px;font-size:20px;text-align:center;color:#fff;background-color:#3b5998;"></div></a>'+'<a target="_blank" class="wonderaudio-button-link" href="https://twitter.com/share?url='+encodeURIComponent(shareUrl)+"&text="+encodeURIComponent(shareTitle)+'"><div class="mhicon-twitter" style="cursor:pointer;display:inline-block;margin:0 12px 0 0;width:32px;height:32px;line-height:32px;font-size:20px;text-align:center;color:#fff;background-color:#03b3ee;"></div></a>'+
'<a target="_blank" class="wonderaudio-button-link" href="https://pinterest.com/pin/create/bookmarklet/?url='+encodeURIComponent(shareUrl)+"&description="+encodeURIComponent(shareTitle)+"&media="+encodeURIComponent(shareMedia)+'"><div class="mhicon-pinterest" style="cursor:pointer;display:inline-block;margin:0 12px 0 0;width:32px;height:32px;line-height:32px;font-size:20px;text-align:center;color:#fff;background-color:#c92228;"></div></a>'+'<a target="_blank" class="wonderaudio-button-link" href="https://api.whatsapp.com/send?text='+
encodeURIComponent(shareTitle+" "+shareUrl)+'" data-action="share/whatsapp/share"><div class="mhicon-whatsapp" style="cursor:pointer;display:inline-block;margin:0 12px 0 0;width:32px;height:32px;line-height:32px;font-size:20px;text-align:center;color:#fff;background-color:#26d466;"></div></a>'+'<a target="_blank" class="wonderaudio-button-link" href="https://www.linkedin.com/shareArticle?mini=true&url='+encodeURIComponent(shareUrl)+"&title="+encodeURIComponent(shareTitle)+"&summary="+encodeURIComponent(shareTitle)+
'"><div class="mhicon-linkedin" style="cursor:pointer;display:inline-block;margin:0 12px 0 0;width:32px;height:32px;line-height:32px;font-size:20px;text-align:center;color:#fff;background-color:#0078b5;"></div></a>'+'<a target="_blank" class="wonderaudio-button-link" href="mailto:?subject='+encodeURIComponent(shareTitle)+"&body="+encodeURIComponent(shareUrl)+'"><div class="mhicon-mail" style="cursor:pointer;display:inline-block;margin:0 12px 0 0;width:32px;height:32px;line-height:32px;font-size:20px;text-align:center;color:#fff;background-color:#4d83ff;"></div></a>'+
this.options.customsharecode+"</div>"+'<div style="position:relative;display:block;width:100%;padding:8px 0;box-sizing:border-box;"><input type="text" class="wonderaudio-social-sharelink" style="width:100%;" value="'+shareUrl+'"></input></div>'+"</div>"+"</div>");socialDialog.appendTo("body");$("input.wonderaudio-social-sharelink").click(function(){this.setSelectionRange(0,this.value.length)});$(".wonderaudio-lightbox-overlay, .wonderaudio-lightbox-close").click(function(){$("#wonderaudio-lightbox").remove()})},
createSkin:function(){this.playerSkin=new PlayerSkin(this,this.container,this.options,this.id)},getParams:function(){var result={};var params=window.location.search.substring(1).split("&");for(var i=0;i<params.length;i++){var value=params[i].split("=");if(value&&value.length==2)result[value[0].toLowerCase().replace(/[&<>]/g,"")]=unescape(value[1]).replace(/[&<>]/g,"")}return result},audioRun:function(index,autoPlay){if(index<-2||index>=this.elemLength)return;var nextItem;if(index==-2)nextItem=this.currentItem<=
0?this.elemLength-1:this.currentItem-1;else if(index==-1)nextItem=this.currentItem>=this.elemLength-1?0:this.currentItem+1;else nextItem=index;this.container.trigger("amazingaudioplayer.switched",{previous:this.currentItem,current:nextItem});$(window).trigger("amazingaudioplayer.switched",{previous:this.currentItem,current:nextItem});this.currentItem=nextItem;this.container.trigger("amazingaudioplayer.updateinfo",this.elemArray[this.currentItem]);$(window).trigger("amazingaudioplayer.updateinfo",
this.elemArray[this.currentItem]);this.audioPlayer.load(this.elemArray[this.currentItem]);if(autoPlay)this.playAudio();clearTimeout(this.liveUpdateTimeout);this.liveUpdateTimeout=null;if(this.elemArray[this.currentItem].live){var src=this.elemArray[this.currentItem].source[0].src;if(this.elemArray[this.currentItem].icecast2status)this.updateLiveIcecast2();else if(src.indexOf("radionomy.com")>0&&this.options.updateradionomy){if(this.elemArray[this.currentItem].radionomyradiouid)this.updateLiveRadionomy()}else if(src.indexOf("shoutcast.com")>
0&&this.options.updateshoutcaststation){if(this.elemArray[this.currentItem].radionomyradiouid)this.updateLiveShoutcastStation()}else if(this.options.updatelivetitle)if(this.options.updatelivetitleinclient)this.updateLiveTitleClient();else this.updateLiveTitle();else if(this.options.updateshoutcast)if(this.options.shoutcastjsonenabled)this.updateLiveShoutcast();else this.updateLiveShoutcastByHTML()}this.checkMK()},updateLiveTitleClient:function(){if(!this.options.updatelivetitleurl)return;var instance=
this;clearTimeout(instance.liveUpdateTimeout);instance.liveUpdateTimeout=null;var src=this.options.updatelivetitleurl;if(this.options.updateclientwithnonce){src+=src.indexOf("?")<0?"?":"&";src+="t="+Math.random().toString(36).substr(2,5)}$.ajax({type:"GET",url:src,dataType:"text"}).done(function(returntitle){var data=[{title:returntitle}];var found=false;for(var j=0;j<instance.liveTracklist.length;j++)if(instance.liveTracklist[j]["title"]==data[0].title){found=true;break}if(!found&&data[0].title){data[0].playedat=
(new Date).getTime()/1E3;instance.liveTracklist.unshift(data[0])}instance.liveTracklist=instance.liveTracklist.slice(0,instance.options.maxplayedlist);instance.drawShoutcast(instance.liveTracklist);instance.liveUpdateTimeout=setTimeout(function(){instance.updateLiveTitleClient()},instance.options.liveupdateinterval)}).fail(function(){})},updateLiveTitle:function(){if(typeof wonderplugin_audio_ajaxobject=="undefined")return;var instance=this;clearTimeout(instance.liveUpdateTimeout);instance.liveUpdateTimeout=
null;var src=instance.options.updatelivetitleurl;var args={type:"POST",data:{action:"wonderplugin_audio_livestation_getcurrent",playerid:instance.id,playedurl:src}};args.url=wonderplugin_audio_ajaxobject.ajaxurl;args.data.nonce=wonderplugin_audio_ajaxobject.nonce;$.ajax(args).done(function(data){if(data&&$.isArray(data)&&data.length>0){for(var i=0;i<data.length;i++){var found=false;for(var j=0;j<instance.liveTracklist.length;j++)if(instance.liveTracklist[j]["title"]==data[i].title){found=true;break}if(!found){data[i].playedat=
(new Date).getTime()/1E3;instance.liveTracklist.unshift(data[i])}}instance.liveTracklist=instance.liveTracklist.slice(0,instance.options.maxplayedlist);instance.drawShoutcast(instance.liveTracklist)}instance.liveUpdateTimeout=setTimeout(function(){instance.updateLiveTitle()},instance.options.liveupdateinterval)})},decodeJsUTF8:function(utftext){var string="";var i=0;var c=c1=c2=0;while(i<utftext.length){c=utftext.charCodeAt(i);if(c<128){string+=String.fromCharCode(c);i++}else if(c>191&&c<224){c2=
utftext.charCodeAt(i+1);string+=String.fromCharCode((c&31)<<6|c2&63);i+=2}else{c2=utftext.charCodeAt(i+1);c3=utftext.charCodeAt(i+2);string+=String.fromCharCode((c&15)<<12|(c2&63)<<6|c3&63);i+=3}}return string},drawShoutcast:function(data){if(!data||!$.isArray(data)||data.length<=0)return;var instance=this;var title=data[0].title;if(title&&title.length>0){instance.elemArray[instance.currentItem].title=title;instance.container.trigger("amazingaudioplayer.updateinfo",instance.elemArray[instance.currentItem])}if(instance.options.showliveplayedlist){var playedlist=
'<div class="amazingaudioplayer-playedlist-title">'+instance.options.playedlisttitle+"</div>";var count=Math.min(instance.options.maxplayedlist,data.length);if(instance.options.addwm&&count>2)count=2;playedlist+='<ul class="amazingaudioplayer-playedlist">';for(var i=0;i<count;i++){var text="";if(data[i].playedat){var date=new Date(data[i].playedat*1E3);text+='<div class="amazingaudioplayer-playedlist-item-shoutcast-time">'+date.toLocaleTimeString()+"</div>"}else if(data[i].playedatstring)text+='<div class="amazingaudioplayer-playedlist-item-shoutcast-time">'+
data[i].playedatstring+"</div>";text+=data[i].title?'<div class="amazingaudioplayer-playedlist-item-shoutcast-title">'+data[i].title+"</div>":"";playedlist+='<li class="amazingaudioplayer-playedlist-item">'+text+"</li>"}playedlist+="</ul>";$(".amazingaudioplayer-playedlist-wrapper",instance.container).html(playedlist)}},updateLiveShoutcast:function(){var instance=this;clearTimeout(instance.liveUpdateTimeout);instance.liveUpdateTimeout=null;var a=$("<a>",{href:this.elemArray[this.currentItem].source[0].src});
var src=a.prop("protocol")+"//"+a.prop("hostname");if(a.prop("port"))src+=":"+a.prop("port");src+="/played?sid=1&type=json";$.ajax({type:"GET",url:src,dataType:"jsonp"}).done(function(data){if(data&&$.isArray(data)&&data.length>0)instance.drawShoutcast(data);instance.liveUpdateTimeout=setTimeout(function(){instance.updateLiveShoutcast()},instance.options.liveupdateinterval)}).fail(function(){instance.updateLiveShoutcastByHTML()})},updateLiveIcecast2:function(){if(typeof wonderplugin_audio_ajaxobject==
"undefined"&&!this.options.icecast2service)return;if(!this.elemArray[this.currentItem].icecast2status)return;var instance=this;clearTimeout(instance.liveUpdateTimeout);instance.liveUpdateTimeout=null;var src=this.elemArray[this.currentItem].icecast2status;var args={type:"POST",data:{action:"wonderplugin_audio_icecast2_gettracklist",playerid:instance.id,playedurl:src,stream:instance.options.streamindex}};if(typeof wonderplugin_audio_ajaxobject!="undefined"){args.url=wonderplugin_audio_ajaxobject.ajaxurl;
args.data.nonce=wonderplugin_audio_ajaxobject.nonce}else args.url=instance.options.icecast2service;$.ajax(args).done(function(data){if(data&&$.isArray(data)&&data.length>0){for(var i=0;i<data.length;i++){var found=false;for(var j=0;j<instance.liveTracklist.length;j++)if(instance.liveTracklist[j]["title"]==data[i].title){found=true;break}if(!found&&data[i].title){data[i].playedat=(new Date).getTime()/1E3;instance.liveTracklist.unshift(data[i])}}instance.liveTracklist=instance.liveTracklist.slice(0,
instance.options.maxplayedlist);instance.drawShoutcast(instance.liveTracklist)}instance.liveUpdateTimeout=setTimeout(function(){instance.updateLiveIcecast2()},instance.options.liveupdateinterval)})},updateLiveShoutcastByHTML:function(){if(typeof wonderplugin_audio_ajaxobject=="undefined"&&!this.options.shoutcastservice)return;var instance=this;clearTimeout(instance.liveUpdateTimeout);instance.liveUpdateTimeout=null;var a=$("<a>",{href:this.elemArray[this.currentItem].source[0].src});var src=a.prop("protocol")+
"//"+a.prop("hostname");if(a.prop("port"))src+=":"+a.prop("port");src+="/played";if(instance.options.shoutcastcustomplayedurl&&instance.options.shoutcastcustomplayedurl.length>0)src=instance.options.shoutcastcustomplayedurl;var args={type:"POST",data:{action:"wonderplugin_audio_shoutcast_gettracklist",playerid:instance.id,playedurl:src}};if(typeof wonderplugin_audio_ajaxobject!="undefined"){args.url=wonderplugin_audio_ajaxobject.ajaxurl;args.data.nonce=wonderplugin_audio_ajaxobject.nonce}else args.url=
instance.options.shoutcastservice;$.ajax(args).done(function(data){if(data&&$.isArray(data)&&data.length>0){for(var i=0;i<data.length;i++){data[i].playedatstring=instance.decodeJsUTF8(data[i].playedatstring);data[i].title=instance.decodeJsUTF8(data[i].title)}instance.drawShoutcast(data)}instance.liveUpdateTimeout=setTimeout(function(){instance.updateLiveShoutcastByHTML()},instance.options.liveupdateinterval)})},updateLiveShoutcastStation:function(){if(typeof wonderplugin_audio_ajaxobject=="undefined")return;
var instance=this;clearTimeout(instance.liveUpdateTimeout);instance.liveUpdateTimeout=null;var args={type:"POST",data:{action:"wonderplugin_audio_shoutcast_station_gettracklist",playerid:instance.id,stationID:this.elemArray[this.currentItem].radionomyradiouid}};args.url=wonderplugin_audio_ajaxobject.ajaxurl;args.data.nonce=wonderplugin_audio_ajaxobject.nonce;$.ajax(args).done(function(data){if(data&&$.isArray(data)&&data.length>0){for(var i=0;i<data.length;i++){data[i].title=instance.decodeJsUTF8(data[i].title);
var found=false;for(var j=0;j<instance.liveTracklist.length;j++)if(instance.liveTracklist[j]["title"]==data[i].title){found=true;break}if(!found){data[i].playedat=(new Date).getTime()/1E3;instance.liveTracklist.unshift(data[i])}}instance.liveTracklist=instance.liveTracklist.slice(0,instance.options.maxplayedlist);instance.drawShoutcast(instance.liveTracklist)}instance.liveUpdateTimeout=setTimeout(function(){instance.updateLiveShoutcastStation()},instance.options.liveupdateinterval)})},updateLiveRadionomy:function(){var instance=
this;clearTimeout(instance.liveUpdateTimeout);instance.liveUpdateTimeout=null;var src="https://api.radionomy.com/currentsong.cfm?radiouid="+this.elemArray[this.currentItem].radionomyradiouid+"&type=xml&cover=yes&callmeback=yes&defaultcover=yes&dynamicconf=yes";$.ajax({type:"GET",url:src,dataType:"xml"}).done(function(data){var tracks=$(data).find("tracks");if(tracks&&tracks.length>0){var track=tracks.find("track");if(track&&track.length>0){var title=track.find("title").text();var artist=track.find("artists").text();
var cover=track.find("cover").text();if(title&&title.length>0)instance.elemArray[instance.currentItem].title=title;if(artist&&artist.length>0)instance.elemArray[instance.currentItem].artist=artist;if(cover&&cover.length>0)instance.elemArray[instance.currentItem].image=cover;instance.container.trigger("amazingaudioplayer.updateinfo",instance.elemArray[instance.currentItem]);var callmeback=track.find("callmeback").text();instance.liveUpdateTimeout=setTimeout(function(){instance.updateLiveRadionomy()},
callmeback)}}});if(instance.options.showliveplayedlist&&(typeof wonderplugin_audio_ajaxobject!="undefined"||instance.options.radionomyservice)){var args={type:"POST",data:{action:"wonderplugin_audio_radionomy_gettracklist",playerid:instance.id,radiouid:instance.elemArray[instance.currentItem].radionomyradiouid}};if(typeof wonderplugin_audio_ajaxobject!="undefined"){args.url=wonderplugin_audio_ajaxobject.ajaxurl;args.data.nonce=wonderplugin_audio_ajaxobject.nonce}else args.url=instance.options.radionomyservice;
$.ajax(args).done(function(data){if(data&&$.isArray(data)&&data.length>0){var playedlist='<div class="amazingaudioplayer-playedlist-title">'+instance.options.playedlisttitle+"</div>";var count=Math.min(instance.options.maxplayedlist,data.length);if(instance.options.addwm&&count>2)count=2;playedlist+='<ul class="amazingaudioplayer-playedlist">';for(var i=0;i<count;i++){var image=data[i].image?data[i].image:"";var title=data[i].title?data[i].title:"";var artist=data[i].artist?data[i].artist:"";var text=
"";if(image)text+='<div class="amazingaudioplayer-playedlist-item-radionomy-image"><img src="'+image+'" alt="'+amEscapeHtml(title)+'" width="'+instance.options.playedlistimagewidth+'" height="'+instance.options.playedlistimageheight+'"></div>';text+='<div class="amazingaudioplayer-playedlist-item-radionomy-text">';text+='<p class="amazingaudioplayer-playedlist-item-radionomy-title">'+title+"</p>";text+='<p class="amazingaudioplayer-playedlist-item-radionomy-artist">'+artist+"</p>";text+="</div>";
text+='<div style="clear:both;"></div>';playedlist+='<li class="amazingaudioplayer-playedlist-item">'+text+"</li>";if(i==0){if(title)instance.elemArray[instance.currentItem].title=title;if(artist)instance.elemArray[instance.currentItem].artist=artist;if(image)instance.elemArray[instance.currentItem].image=image;instance.container.trigger("amazingaudioplayer.updateinfo",instance.elemArray[instance.currentItem])}}playedlist+="</ul>";$(".amazingaudioplayer-playedlist-wrapper").html(playedlist)}})}},
checkMK:function(){if(this.options.vm=="AMF"+"ree"){var mklink=$(".amazingaudioplayer-mark",this.container);if(mklink.length<0||mklink.text().indexOf(this.options.pvm)<0||mklink.attr("href")!==this.options.lvm)this.container.append('<a href="'+this.options.lvm+'" target="_blank" class="amazingaudioplayer-mark"><div style="display:block!important;visibility:visible!important;z-index:999;position:absolute!important;top:100%!important;right:0!important;margin:4px!important;padding:0px!important;text-align:right;font:normal 10px Arial,sans-serif;font-size:10px!important;color:#666!important;">WordPress Audio Player Trial Version</div></a>');
else{var mkdiv=mklink.parent();if(mklink.css("display")=="none"||mklink.css("visibility")=="hidden"||parseInt(mklink.css("font-size"))<8||mkdiv.css("display")=="none"||mkdiv.css("visibility")=="hidden"||parseInt(mkdiv.css("font-size"))<8){mklink.attr({style:(mklink.attr("style")||"")+"display:block!important;visibility:visible!important;color:#666!important;font-size:10px!important;"});mkdiv.attr({style:mkdiv.attr("style")+"display:block!important;visibility:visible!important;color:#666!important;font-size:10px!important;"})}}}},
onAudioEnded:function(){this.container.trigger("amazingaudioplayer.ended",this.currentItem);switch(this.options.loop){case 0:if(!this.options.noncontinous&&this.currentItem<this.elemLength-1)this.audioRun(-1,true);else this.stopAudio();break;case 1:this.audioRun(-1,true);break;case 2:this.audioRun(this.currentItem,true);break}},stopOthers:function(){if(wonderpluginaudioObjects&&wonderpluginaudioObjects.objects)for(var i=0;i<wonderpluginaudioObjects.objects.length;i++){if(wonderpluginaudioObjects.objects[i]==
this)continue;if(this.options.stopotherthanpause)wonderpluginaudioObjects.objects[i].stopAudio();else wonderpluginaudioObjects.objects[i].pauseAudio()}if($("video:not(#amazingaudioobject-"+this.id+")",this.container).length){$("video:not(#amazingaudioobject-"+this.id+")",this.container).get(0).pause();if(this.options.stopotherthanpause)$("video:not(#amazingaudioobject-"+this.id+")",this.container).get(0).currentTime=0}},reloadPlayAudio:function(){for(var i=0;i<this.elemArray[this.currentItem].source.length;i++){var src=
this.elemArray[this.currentItem].source[i].src;var index=src.indexOf("?amazingrnd=");if(index>0)src=src.substring(0,index);index=src.indexOf("&amazingrnd=");if(index>0)src=src.substring(0,index);src=src+(src.indexOf("?")<0?"?":"&")+"amazingrnd="+Math.random().toString(36).slice(2);this.elemArray[this.currentItem].source[i].src=src}this.audioPlayer.load(this.elemArray[this.currentItem]);this.audioPlayer.play();this.container.trigger("amazingaudioplayer.played",this.currentItem);if(this.options.stopotherplayers)this.stopOthers()},
playAudio:function(startTime){this.audioPlayer.play(startTime,this.elemArray[this.currentItem].duration);this.container.trigger("amazingaudioplayer.played",this.currentItem);if(this.options.stopotherplayers)this.stopOthers()},pauseAudio:function(){this.audioPlayer.pause();this.container.trigger("amazingaudioplayer.paused",this.currentItem)},stopAudio:function(){this.audioPlayer.stop();this.container.trigger("amazingaudioplayer.stopped",this.currentItem);this.container.trigger("amazingaudioplayer.playprogress",
{current:0,duration:0,live:this.elemArray[this.currentItem].live})},setVolume:function(volume){this.audioPlayer.setVolume(volume);this.container.trigger("amazingaudioplayer.setvolume",volume)},setPlaybackRate:function(rate){this.options.playbackrate=rate;this.audioPlayer.setPlaybackRate(rate);this.container.trigger("amazingaudioplayer.setplaybackrate",rate)},loadProgress:function(progress){this.container.trigger("amazingaudioplayer.loadprogress",progress)},playProgress:function(current,duration){if(current==
0&&duration==1E5)return;var d0=this.elemArray[this.currentItem].duration*1E3>duration||isNaN(duration)||!isFinite(duration)?this.elemArray[this.currentItem].duration*1E3:duration;this.container.trigger("amazingaudioplayer.playprogress",{current:current,duration:d0,live:this.elemArray[this.currentItem].live})},setTime:function(pos){this.audioPlayer.setTime(pos,this.elemArray[this.currentItem].duration)},getSeconds:function(){return this.audioPlayer.getSeconds()},setSeconds:function(seconds){this.audioPlayer.setSeconds(seconds)},
rewind:function(seconds){this.audioPlayer.setSeconds(this.audioPlayer.getSeconds()-seconds)},forward:function(seconds){this.audioPlayer.setSeconds(this.audioPlayer.getSeconds()+seconds)},reInitPlayer:function(){if(this.container.find("audio").length>0)this.container.find("audio").get(0).setAttribute("src","");this.container.children().not(".amazingaudioplayer-audios").remove();this.elemArray=new Array;this.initPlayer()}};var bts=function(string){var ret="";var bytes=string.split(",");for(var i=0;i<
bytes.length;i++)ret+=String.fromCharCode(bytes[i]);return ret};options=options||{};for(var key in options)if(key.toLowerCase()!==key){options[key.toLowerCase()]=options[key];delete options[key]}this.each(function(){if($(this).data("donotinit")&&(!options||!options["forceinit"]))return;if($(this).data("inited"))return;$(this).data("inited",1);this.options=$.extend({},options);this.options.fvm=bts("119,111,110,100,101,114,112,108,117,103,105,110,46,99,111,109");if($(this).data("skin")&&
typeof WONDERPLUGIN_AUDIO_SKIN_OPTIONS!=="undefined")if($(this).data("skin")in WONDERPLUGIN_AUDIO_SKIN_OPTIONS)this.options=$.extend({},WONDERPLUGIN_AUDIO_SKIN_OPTIONS[$(this).data("skin")],this.options);var instance=this;$.each($(this).data(),function(key,value){instance.options[key.toLowerCase()]=value});if(typeof wonderpluginaudio_options!="undefined"&&wonderpluginaudio_options)this.options=$.extend(this.options,wonderpluginaudio_options);if($("div#wonderpluginaudio_options").length)$.each($("div#wonderpluginaudio_options").data(),
function(key,value){instance.options[key.toLowerCase()]=value});var searchoptions={};var searchstring=window.location.search.substring(1).split("&");for(var i=0;i<searchstring.length;i++){var keyvalue=searchstring[i].split("=");if(keyvalue&&keyvalue.length==2){var key=keyvalue[0].toLowerCase().replace(/[&<>]/g,"");var value=unescape(keyvalue[1]).toLowerCase().replace(/[&<>]/g,"");if(value=="true")searchoptions[key]=true;else if(value=="false")searchoptions[key]=false;else searchoptions[key]=value}}this.options=
$.extend(this.options,searchoptions);this.options.lvm=bts("104,116,116,112,58,47,47,119,119,119,46,119,111,110,100,101,114,112,108,117,103,105,110,46,99,111,109,47,119,111,114,100,112,114,101,115,115,45,97,117,100,105,111,45,112,108,97,121,101,114,47");var defaultOptions={autoplay:false,loop:0,random:true,autoplaytimeout:1E3,maxlen:3,wptracklist:false,forceurltohttp:false,playbackrate:1,stopotherplayers:true,stopotherthanpause:false,reloadstream:false,updateradionomy:true,updateshoutcaststation:true,updateshoutcast:true,liveupdateinterval:2E4,showliveplayedlist:false,maxplayedlist:8,
playedlisttitle:"Last Tracks Played",playedlistimagewidth:50,playedlistimageheight:50,livetitle:"LIVE",streamindex:0,shoutcastjsonenabled:false,shoutcastcustomplayedurl:"",disablehoverontouch:false,saveposincookie:false,cookiehours:24,enabletabindex:false,playerviewdelay:0,enablega:false,gatrackingid:"",gacategory:"Audio Player",gaeventvalue:1,ga4account:"",enablega4:true,stoponpausebutton:false,noncontinous:false,preloadaudio:true,defaultvolume:-1,skinsfoldername:"",playpauseimage:"playpause-28-28-0.png",
playpauseimagewidth:28,playpauseimageheight:28,playpausefont:false,playpausefontsize:14,playpausefontcolor:"#fff",playpausefontbgcolor:"#333",playpausefonthovercolor:"#fff",playpausefonthoverbgcolor:"#555",playpausefontradius:0,playpausefontcircle:false,prevfont:false,prevfontsize:14,prevfontcolor:"#fff",prevfontbgcolor:"#333",prevfonthovercolor:"#fff",prevfonthoverbgcolor:"#555",prevfontradius:0,prevfontcircle:false,nextfont:false,nextfontsize:14,nextfontcolor:"#fff",nextfontbgcolor:"#333",nextfonthovercolor:"#fff",
nextfonthoverbgcolor:"#555",nextfontradius:0,nextfontcircle:false,showstop:true,stopimage:"stop-32-32-0.png",stopimagewidth:32,stopimageheight:32,showprevnext:true,prevnextimage:"prevnext-32-32-0.png",prevnextimagewidth:32,prevnextimageheight:32,showloop:true,loopimage:"loop-32-32-0.png",loopimagewidth:32,loopimageheight:32,loopfont:false,loopfontsize:16,loopfontcolor:"#fff",loopfontbgcolor:"#333",loopfonthovercolor:"#fff",loopfonthoverbgcolor:"#555",loopfontradius:0,loopfontcircle:false,showtitleinbar:true,
titleinbarwidth:80,titleinbarwidthmode:"fixed",titleinbarformat:"%TITLE%",titleinbarscroll:true,showinfoinbar:false,infoinbarformat:"%INFO%",showprogress:true,progressheight:20,progressinbar:true,showtime:true,timeformat:"%CURRENT% / %DURATION%",timeformatlive:"%CURRENT% / LIVE",showloading:false,loadingformat:"Loading...",customtimestyle:false,timestyle:"%HOURS% : %MINUTES% : %SECONSD%",showvolume:true,showvolumebar:true,volumeimage:"volume-32-32-0.png",volumeimagewidth:24,volumeimageheight:24,volumebarpadding:6,
volumebarwidth:24,volumebarheight:100,volumebarposition:"top",volumefont:false,volumefontsize:14,volumefontcolor:"#fff",volumefontbgcolor:"#333",volumefonthovercolor:"#fff",volumefonthoverbgcolor:"#555",volumefontradius:0,volumefontcircle:false,showtitle:true,titleformat:"%TITLE%",showinfo:true,infoformat:"By %ARTIST% - %ALBUM%",showimage:true,imagewidth:160,imageheight:160,imagefullwidth:false,showtracklistsearch:false,searchplaceholder:"Search",searchtitleonly:false,showtracklist:true,tracklistitem:2,
tracklistitemformat:"<div class='amazingaudioplayer-item-id'>%ID%</div><div class='amazingaudioplayer-item-info'>%DURATION%</div><div class='amazingaudioplayer-item-title'>%TITLE%</div>",tracklistarrowimage:"tracklist-arrow-32-32-0.png",tracklistarrowimagewidth:32,tracklistarrowimageheight:32,changeemptytitletospace:true,tracklistscroll:true,tracklistpadding:24,tracklistbarwidth:8,tracklistbarbgcolor:"#333",tracklistthumbcolor:"#fff",tracklistthumbopacity:.8,tracklistenablepagescroll:true,showbackgroundimage:false,
backgroundimage:"background-0.png",showbarbackgroundimage:false,barbackgroundimage:"barbackground-0.png",showtracklistbackgroundimage:false,tracklistbackgroundimage:"tracklistbarbackground-0.png",downloadbutton:'<a href="%AUDIOURL%" class="wonderaudio-button-link wonderaudio-download-link" download="%AUDIOFILE%" target="_blank" onclick="event.stopPropagation();"><div class="mhicon-download wonderaudio-button wonderaudio-download"></div></a>',sharebutton:'<div class="mhicon-share wonderaudio-button wonderaudio-share"></div>',
sharetitleformat:"%TITLE%",defaultsharetitle:"Check This Out",customsharecode:"",shareaudiourl:false,updatelivetitle:false,updatelivetitleinclient:false,updatelivetitleurl:"",updateclientwithnonce:true,vm:"AMFree"};this.options.pvm=bts("87,111,114,100,80,114,101,115,115,32,65,117,100,105,111,32,80,108,97,121,101,114,32,84,114,105,97,108,32,86,101,114,115,105,111,110");this.options=$.extend(defaultOptions,this.options);this.options.htmlfolder=window.location.href.substr(0,window.location.href.lastIndexOf("/")+1);
this.options.skinsfolder=this.options.jsfolder;if(this.options.skinsfoldername.length>0)this.options.skinsfolder+=this.options.skinsfoldername;if(this.options.skinsfolder.length>0&&this.options.skinsfolder[this.options.skinsfolder.length-1]!="/")this.options.skinsfolder+="/";var image_list=["playpauseimage","stopimage","prevnextimage","loopimage","volumeimage","tracklistarrowimage","backgroundimage","barbackgroundimage","tracklistbackgroundimage"];for(var i=0;i<image_list.length;i++)if(this.options[image_list[i]])if(this.options[image_list[i]].substring(0,
7).toLowerCase()!="http://"&&this.options[image_list[i]].substring(0,8).toLowerCase()!="https://")this.options[image_list[i]]=this.options.skinsfolder+this.options[image_list[i]];this.options.addwm=this.options.vm!=bts("65,77,67,111,109");var audioplayerid;if("audioplayerid"in this.options)audioplayerid=this.options.audioplayerid;else{audioplayerid=wonderpluginaudioId;wonderpluginaudioId++}var object=new AmazingAudioPlayer($(this),this.options,audioplayerid);$(this).data("object",object);$(this).data("id",
audioplayerid);wonderpluginaudioObjects.addObject(object);object.initPlayer()})};$.amascrollbar_clear=function(parent,child){$(".amascrollbar",parent).remove();child.css({"margin-top":0})};$.amascrollbar=function(parent,child,options){options=$.extend({barwidth:8,barbgcolor:"#222",thumbcolor:"#fff",thumbopacity:.8,enablepagescroll:true},options);var totalheight=child.height();var visibleheight=parent.height();var thumbheight=Math.ceil(visibleheight*visibleheight/totalheight);if(thumbheight<30)thumbheight=
30;var scrollbar=$('<div class="amascrollbar"></div>');scrollbar.css({position:"absolute",top:0,bottom:0,right:0,display:"block",width:options.barwidth+"px","border-radius":Math.ceil(options.barwidth/2)+"px","background-color":options.barbgcolor});parent.append(scrollbar);var scrollthumb=$('<div class="amascrollthumb"></div>');scrollthumb.css({position:"absolute",top:0,right:0,display:"block",width:options.barwidth+"px",height:thumbheight+"px","border-radius":Math.ceil(options.barwidth/2)+"px","background-color":options.thumbcolor,
opacity:options.thumbopacity,cursor:"pointer"});scrollbar.append(scrollthumb);scrollbar.hover(function(){scrollthumb.css({opacity:1})},function(){scrollthumb.css({opacity:options.thumbopacity})});scrollbar.click(function(e){var offset=$(this).offset();var top=e.pageY-offset.top;var thumbtop=scrollthumb.position().top;var newtop=thumbtop;if(top>thumbtop+thumbheight)newtop=thumbtop+thumbheight;else if(top<thumbtop)newtop=thumbtop-thumbheight;if(newtop<0)newtop=0;if(newtop>visibleheight-thumbheight)newtop=
visibleheight-thumbheight;scrollthumb.css({top:newtop+"px"});child.css({"margin-top":(visibleheight-totalheight)*newtop/(visibleheight-thumbheight)+"px"})});scrollthumb.on("mousedown",function(e){var dragged=$(this);var y=dragged.offset().top-e.pageY;$(document).on("mousemove.amadraggable",function(e){var t=y+e.pageY;if(t<scrollbar.offset().top)t=scrollbar.offset().top;if(t>scrollbar.offset().top+visibleheight-thumbheight)t=scrollbar.offset().top+visibleheight-thumbheight;dragged.offset({top:t});
var newtop=scrollthumb.offset().top-scrollbar.offset().top;child.css({"margin-top":(visibleheight-totalheight)*newtop/(visibleheight-thumbheight)+"px"});e.preventDefault()});$(document).one("mouseup",function(e){$(this).off("mousemove.amadraggable")})});var scrollChild=function(dis){var childtop=parseInt(child.css("margin-top"));if(options.enablepagescroll){if(childtop==0&&dis>=0)return false;if(childtop==visibleheight-totalheight&&dis<=0)return false}childtop+=dis;if(childtop>0)childtop=0;if(childtop<
visibleheight-totalheight)childtop=visibleheight-totalheight;child.css({"margin-top":childtop+"px"});var thumbtop=childtop*(visibleheight-thumbheight)/(visibleheight-totalheight);if(thumbtop<0)thumbtop=0;if(thumbtop>visibleheight-thumbheight)thumbtop=visibleheight-thumbheight;scrollthumb.css({top:thumbtop+"px"});return true};parent.on("DOMMouseScroll mousewheel wheel",function(e){var dis=0;if(e.originalEvent)if(e.originalEvent.wheelDeltaY)dis=e.originalEvent.wheelDeltaY;else if(e.originalEvent.deltaY)dis=
-e.originalEvent.deltaY;var ret=scrollChild(dis);if(ret)e.preventDefault()});if("ontouchstart"in window){var startY=-1;var curY=-1;parent.on("touchstart",function(event){var e=event.originalEvent;if(e.targetTouches.length>=1)startY=e.targetTouches[0].pageY;else{startY=-1;curY=-1}});parent.on("touchmove",function(event){var e=event.originalEvent;if(e.targetTouches.length>=1){curY=e.targetTouches[0].pageY;if(curY>0)if(Math.abs(curY-startY)>10){var ret=scrollChild(curY-startY);if(ret)event.preventDefault()}}else{startY=
-1;curY=-1}});parent.on("touchend",function(event){startY=-1;curY=-1});parent.on("touchCancel",function(event){startY=-1;curY=-1})}};$.amaudioCookie=function(key,value,options){if(typeof value!=="undefined"){options=$.extend({},{path:"/"},options);if(options.expires){var seconds=options.expires;options.expires=new Date;options.expires.setTime(options.expires.getTime()+seconds*1E3)}return document.cookie=key+"="+encodeURIComponent(value)+(options.expires?";expires="+options.expires.toUTCString():"")+
(options.path?";path="+options.path:"")}var result=null;var cookies=document.cookie?document.cookie.split(";"):[];for(var i in cookies){var parts=$.trim(cookies[i]).split("=");if(parts.length&&parts[0]==key){result=decodeURIComponent(parts[1]);break}}return result};$.amaudioRemoveCookie=function(key){return $.amaudioCookie(key,"",$.extend({},{expires:-1}))}})(jQuery);if(typeof wonderpluginaudioId==="undefined")var wonderpluginaudioId=0;
if(typeof wonderpluginaudioObjects==="undefined")var wonderpluginaudioObjects=new function(){this.objects=[];this.addObject=function(obj){this.objects.push(obj)}};
jQuery(document).ready(function(){jQuery(".wonderplugin-engine").css({display:"none"});if (jQuery.fn.wonderpluginaudio) jQuery(".wonderpluginaudio").wonderpluginaudio();});
