/**
 * WonderPlugin Audio Player Skin Options
 * Copyright 2014 Magic Hills Pty Ltd - http://www.wonderplugin.com
 */

var WONDERPLUGIN_AUDIO_SKIN_TEMPLATE = {
	darkbox: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: border-box;\n	background-color: #333;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n    	-moz-border-radius: 2px;\n    	border-radius: 2px;\n	margin: 4px;\n	padding: 8px 4px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: border-box;\n	-moz-box-sizing: border-box;\n	box-sizing: border-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image img {\n	display: inline-block;\n	margin: 0;\n	padding: 0;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	text-align: left;\n	overflow: hidden;\n	padding: 4px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #eee;\n	font-family: Open Sans,Arial,sans-serif;\n	font-size: 12px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	color: #ddd;\n	font-family: Arial, sans-serif;\n	font-size: 11px;\n	font-style: italic;\n	margin-top: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	position: relative;\n	width: 100%;\n	min-height: 64px;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #eee;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: absolute;\n	top: 0;\n	left: 40px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: absolute;\n	top: 0;\n	left: 0px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: absolute;\n	top: 0;\n	left: 80px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: absolute;\n	top: 12px;\n	left: 124px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: absolute;\n	top: 42px;\n	left: 0px;\n	right: 0px;\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	margin: 8px 4px;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #444;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	background-color: #e6e3da;\n	background-image: -ms-linear-gradient(top, #fcfcfc 0%, #e6e3da 100%);\n	background-image: -moz-linear-gradient(top, #fcfcfc 0%, #e6e3da 100%);\n	background-image: -o-linear-gradient(top, #fcfcfc 0%, #e6e3da 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #fcfcfc), color-stop(1, #e6e3da));\n	background-image: -webkit-linear-gradient(top, #fcfcfc 0%, #e6e3da 100%); \n	background-image: linear-gradient(to bottom, #fcfcfc 0%, #e6e3da 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #fff;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	text-shadow: 1px 1px 0 #000;\n	line-height: 24px;\n	margin: 12px 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: absolute;\n	top: 12px;\n	left: 154px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #333;\n	border: none;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #f0f0f0;\n	-webkit-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	-moz-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	margin: 4px;\n	padding: 8px 0px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #999;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	text-shadow: 0 1px 1px rgba(0, 0, 0, 0.6);\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #999;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #fff;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: -5px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: -5px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #eee;\n}'
	},
	bar: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n	-webkit-box-shadow: 0 8px 6px -6px black;\n	-moz-box-shadow: 0 8px 6px -6px black;\n	box-shadow: 0 8px 6px -6px black;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	overflow: hidden;\n	padding: 4px 12px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n	clear: both;\n	height: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	font-family: "Oswald",Arial,sans-serif;\n	font-size: 20px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	display: block;\n	color: #666;\n	font-family: Arial, sans-serif;\n	font-size: 12px;\n	font-style: italic;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	background-color: #333;\n	margin: 4px;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #222222));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #222222 100%); \n	background-image: linear-gradient(to bottom, #444444 0%, #222222 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #eee;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	margin: 8px 4px;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #444;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	background-color: #fcc500;\n	background-image: -ms-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -moz-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -o-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #fede00), color-stop(1, #fcc500));\n	background-image: -webkit-linear-gradient(top, #fede00 0%, #fcc500 100%); \n	background-image: linear-gradient(to bottom, #fede00 0%, #fcc500 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #fff;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	text-shadow: 1px 1px 0 #000;\n	line-height: 24px;\n	margin: 0 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #333;\n	border: none;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #fcc500;\n	-webkit-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	-moz-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	background-color: #333;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n    -moz-border-radius: 2px;\n    border-radius: 2px;\n	margin: 4px;\n	padding: 12px 12px 16px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #999;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	text-shadow: 0 1px 1px rgba(0, 0, 0, 0.6);\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #999;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #fff;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #eee;\n}'
	},
	barwithplaylist: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n	-webkit-box-shadow: 0 8px 6px -6px black;\n	-moz-box-shadow: 0 8px 6px -6px black;\n	box-shadow: 0 8px 6px -6px black;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	overflow: hidden;\n	padding: 4px 12px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n	clear: both;\n	height: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	font-family: "Oswald",Arial,sans-serif;\n	font-size: 20px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	display: block;\n	color: #666;\n	font-family: Arial, sans-serif;\n	font-size: 12px;\n	font-style: italic;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	background-color: #333;\n	margin: 4px;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #222222));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #222222 100%); \n	background-image: linear-gradient(to bottom, #444444 0%, #222222 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #eee;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	margin: 8px 4px;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #444;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	background-color: #fcc500;\n	background-image: -ms-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -moz-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -o-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #fede00), color-stop(1, #fcc500));\n	background-image: -webkit-linear-gradient(top, #fede00 0%, #fcc500 100%); \n	background-image: linear-gradient(to bottom, #fede00 0%, #fcc500 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #fff;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	text-shadow: 1px 1px 0 #000;\n	line-height: 24px;\n	margin: 0 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #333;\n	border: none;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #fcc500;\n	-webkit-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	-moz-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	background-color: #333;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n    -moz-border-radius: 2px;\n    border-radius: 2px;\n	margin: 4px;\n	padding: 12px 12px 16px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #999;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	text-shadow: 0 1px 1px rgba(0, 0, 0, 0.6);\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #999;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #fff;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #eee;\n}'
	},
	bartitle: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n	-webkit-box-shadow: 0 8px 6px -6px black;\n	-moz-box-shadow: 0 8px 6px -6px black;\n	box-shadow: 0 8px 6px -6px black;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	overflow: hidden;\n	padding: 4px 12px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n	clear: both;\n	height: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	font-family: "Oswald",Arial,sans-serif;\n	font-size: 20px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	display: block;\n	color: #666;\n	font-family: Arial, sans-serif;\n	font-size: 12px;\n	font-style: italic;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	background-color: #333;\n	margin: 4px;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #222222));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #222222 100%); \n	background-image: linear-gradient(to bottom, #444444 0%, #222222 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #eee;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	margin: 8px 4px;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #444;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	background-color: #fcc500;\n	background-image: -ms-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -moz-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -o-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #fede00), color-stop(1, #fcc500));\n	background-image: -webkit-linear-gradient(top, #fede00 0%, #fcc500 100%); \n	background-image: linear-gradient(to bottom, #fede00 0%, #fcc500 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #fff;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	text-shadow: 1px 1px 0 #000;\n	line-height: 24px;\n	margin: 0 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #333;\n	border: none;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #fcc500;\n	-webkit-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	-moz-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	background-color: #333;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n    -moz-border-radius: 2px;\n    border-radius: 2px;\n	margin: 4px;\n	padding: 12px 12px 16px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #999;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	text-shadow: 0 1px 1px rgba(0, 0, 0, 0.6);\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #999;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #fff;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #eee;\n}'
	},
	barwhite: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n	-webkit-box-shadow: 0 8px 6px -6px black;\n	-moz-box-shadow: 0 8px 6px -6px black;\n	box-shadow: 0 8px 6px -6px black;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	overflow: hidden;\n	padding: 4px 12px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n	clear: both;\n	height: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	font-family: "Oswald",Arial,sans-serif;\n	font-size: 20px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	display: block;\n	color: #333;\n	font-family: Arial, sans-serif;\n	font-size: 12px;\n	font-style: italic;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	background-color: #f6f6f6;\n	margin: 4px;\n	border: 1px solid #cbcbcb;\n	background-image: -moz-linear-gradient(top,  #ffffff 0%, #f1f1f1 50%, #e1e1e1 51%, #f6f6f6 100%); \n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffffff), color-stop(50%,#f1f1f1), color-stop(51%,#e1e1e1), color-stop(100%,#f6f6f6)); \n	background-image: -webkit-linear-gradient(top,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%); \n	background-image: -o-linear-gradient(top,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%); \n	background-image: -ms-linear-gradient(top,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%);\n	background-image: linear-gradient(to bottom,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%); \n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="#ffffff", endColorstr="#f6f6f6",GradientType=0 ); \n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #444444;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #706d6d;\n	margin: 8px 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #999;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	background-color: #73b3c3;\n	background-image: -ms-linear-gradient(top, #90d9e4 0%, #368fae 100%);\n	background-image: -moz-linear-gradient(top, #90d9e4 0%, #368fae 100%);\n	background-image: -o-linear-gradient(top, #90d9e4 0%, #368fae 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #90d9e4), color-stop(1, #368fae));\n	background-image: -webkit-linear-gradient(top, #90d9e4 0%, #368fae 100%); \n	background-image: linear-gradient(to bottom, #90d9e4 0%, #368fae 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #555555;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	text-shadow: 0px 0px 1px rgba(0, 0, 0, 0.1);\n	line-height: 24px;\n	margin: 0 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	margin-bottom: 2px;\n	background-color: #e1e1e1;\n	background-image: -ms-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -moz-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -o-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #f6f6f6), color-stop(1, #e1e1e1));\n	background-image: -webkit-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: linear-gradient(to bottom, #f6f6f6 0%, #e1e1e1 100%);	\n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #555;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #4ba4bd;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	-webkit-border-radius: 2px;\n   	 -moz-border-radius: 2px;\n    	border-radius: 2px;\n	margin: 4px;\n	padding: 12px 12px 16px;\n	background-color: #e1e1e1;\n	border: 1px solid #cbcbcb;\n	background-image: -ms-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -moz-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -o-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #f6f6f6), color-stop(1, #e1e1e1));\n	background-image: -webkit-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: linear-gradient(to bottom, #f6f6f6 0%, #e1e1e1 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #666;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #222;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #666;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #222;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	barwhitewithplaylist: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n	-webkit-box-shadow: 0 8px 6px -6px black;\n	-moz-box-shadow: 0 8px 6px -6px black;\n	box-shadow: 0 8px 6px -6px black;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	overflow: hidden;\n	padding: 4px 12px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n	clear: both;\n	height: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	font-family: "Oswald",Arial,sans-serif;\n	font-size: 20px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	display: block;\n	color: #333;\n	font-family: Arial, sans-serif;\n	font-size: 12px;\n	font-style: italic;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	background-color: #f6f6f6;\n	margin: 4px;\n	border: 1px solid #cbcbcb;\n	background-image: -moz-linear-gradient(top,  #ffffff 0%, #f1f1f1 50%, #e1e1e1 51%, #f6f6f6 100%); \n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffffff), color-stop(50%,#f1f1f1), color-stop(51%,#e1e1e1), color-stop(100%,#f6f6f6)); \n	background-image: -webkit-linear-gradient(top,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%); \n	background-image: -o-linear-gradient(top,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%); \n	background-image: -ms-linear-gradient(top,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%);\n	background-image: linear-gradient(to bottom,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%); \n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="#ffffff", endColorstr="#f6f6f6",GradientType=0 ); \n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #444444;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #706d6d;\n	margin: 8px 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #999;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	background-color: #73b3c3;\n	background-image: -ms-linear-gradient(top, #90d9e4 0%, #368fae 100%);\n	background-image: -moz-linear-gradient(top, #90d9e4 0%, #368fae 100%);\n	background-image: -o-linear-gradient(top, #90d9e4 0%, #368fae 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #90d9e4), color-stop(1, #368fae));\n	background-image: -webkit-linear-gradient(top, #90d9e4 0%, #368fae 100%); \n	background-image: linear-gradient(to bottom, #90d9e4 0%, #368fae 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #555555;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	text-shadow: 0px 0px 1px rgba(0, 0, 0, 0.1);\n	line-height: 24px;\n	margin: 0 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	margin-bottom: 2px;\n	background-color: #e1e1e1;\n	background-image: -ms-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -moz-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -o-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #f6f6f6), color-stop(1, #e1e1e1));\n	background-image: -webkit-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: linear-gradient(to bottom, #f6f6f6 0%, #e1e1e1 100%);	\n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #555;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #4ba4bd;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	-webkit-border-radius: 2px;\n   	 -moz-border-radius: 2px;\n    	border-radius: 2px;\n	margin: 4px;\n	padding: 12px 12px 16px;\n	background-color: #e1e1e1;\n	border: 1px solid #cbcbcb;\n	background-image: -ms-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -moz-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -o-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #f6f6f6), color-stop(1, #e1e1e1));\n	background-image: -webkit-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: linear-gradient(to bottom, #f6f6f6 0%, #e1e1e1 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #666;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #222;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #666;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #222;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	barwhitetitle: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n	-webkit-box-shadow: 0 8px 6px -6px black;\n	-moz-box-shadow: 0 8px 6px -6px black;\n	box-shadow: 0 8px 6px -6px black;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	overflow: hidden;\n	padding: 4px 12px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n	clear: both;\n	height: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	font-family: "Oswald",Arial,sans-serif;\n	font-size: 20px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	display: block;\n	color: #333;\n	font-family: Arial, sans-serif;\n	font-size: 12px;\n	font-style: italic;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	background-color: #f6f6f6;\n	margin: 4px;\n	border: 1px solid #cbcbcb;\n	background-image: -moz-linear-gradient(top,  #ffffff 0%, #f1f1f1 50%, #e1e1e1 51%, #f6f6f6 100%); \n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#ffffff), color-stop(50%,#f1f1f1), color-stop(51%,#e1e1e1), color-stop(100%,#f6f6f6)); \n	background-image: -webkit-linear-gradient(top,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%); \n	background-image: -o-linear-gradient(top,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%); \n	background-image: -ms-linear-gradient(top,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%);\n	background-image: linear-gradient(to bottom,  #ffffff 0%,#f1f1f1 50%,#e1e1e1 51%,#f6f6f6 100%); \n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="#ffffff", endColorstr="#f6f6f6",GradientType=0 ); \n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #444444;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #706d6d;\n	margin: 8px 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #999;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	background-color: #73b3c3;\n	background-image: -ms-linear-gradient(top, #90d9e4 0%, #368fae 100%);\n	background-image: -moz-linear-gradient(top, #90d9e4 0%, #368fae 100%);\n	background-image: -o-linear-gradient(top, #90d9e4 0%, #368fae 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #90d9e4), color-stop(1, #368fae));\n	background-image: -webkit-linear-gradient(top, #90d9e4 0%, #368fae 100%); \n	background-image: linear-gradient(to bottom, #90d9e4 0%, #368fae 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #555555;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	text-shadow: 0px 0px 1px rgba(0, 0, 0, 0.1);\n	line-height: 24px;\n	margin: 0 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	margin-bottom: 2px;\n	background-color: #e1e1e1;\n	background-image: -ms-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -moz-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -o-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #f6f6f6), color-stop(1, #e1e1e1));\n	background-image: -webkit-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: linear-gradient(to bottom, #f6f6f6 0%, #e1e1e1 100%);	\n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #555;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #4ba4bd;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	-webkit-border-radius: 2px;\n   	 -moz-border-radius: 2px;\n    	border-radius: 2px;\n	margin: 4px;\n	padding: 12px 12px 16px;\n	background-color: #e1e1e1;\n	border: 1px solid #cbcbcb;\n	background-image: -ms-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -moz-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -o-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #f6f6f6), color-stop(1, #e1e1e1));\n	background-image: -webkit-linear-gradient(top, #f6f6f6 0%, #e1e1e1 100%);\n	background-image: linear-gradient(to bottom, #f6f6f6 0%, #e1e1e1 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #666;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #222;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #666;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #222;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	jukebox: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 0;\n	overflow: hidden;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image img {\n	display: inline-block;\n	margin: 0;\n	padding: 0;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	text-align: left;\n	overflow: hidden;\n	padding: 0 0 0 8px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	font-family: "Oswald",Arial,sans-serif;\n	font-size: 15px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	color: #666;\n	font-family: Arial, sans-serif;\n	font-size: 12px;\n	font-style: italic;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	position: relative;\n	box-sizing: border-box;\n	width: 100%;\n	float: left;\n	background-color: #333;\n	margin: 6px 0;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n	-moz-border-radius: 2px;\n	border-radius: 2px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #222222 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #222222));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #222222 100%); \n	background-image: linear-gradient(to bottom, #444444 0%, #222222 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #eee;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	margin: 8px 4px;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #444;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	background-color: #fcc500;\n	background-image: -ms-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -moz-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -o-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #fede00), color-stop(1, #fcc500));\n	background-image: -webkit-linear-gradient(top, #fede00 0%, #fcc500 100%); \n	background-image: linear-gradient(to bottom, #fede00 0%, #fcc500 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #fff;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	text-shadow: 1px 1px 0 #000;\n	line-height: 24px;\n	margin: 0 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #333;\n	border: none;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #fcc500;\n	-webkit-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	-moz-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	background-color: #333;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n    -moz-border-radius: 2px;\n    border-radius: 2px;\n	margin: 0;\n	padding: 12px 12px 16px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #999;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	text-shadow: 0 1px 1px rgba(0, 0, 0, 0.6);\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #999;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #fff;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #eee;\n}'
	},
	whitebox: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image img {\n	display: inline-block;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	text-align: left;\n	overflow: hidden;\n	padding: 8px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	font-family: Open Sans,Arial,sans-serif;\n	font-size: 14px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	color: #666;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	position: relative;\n	width: auto;\n	float: left;\n	padding: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #eee;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #444;\n	margin: 8px 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #666;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	background-color: #fcc500;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #fff;\n	font: bold 12px Open Sans, sans-serif;\n	margin: 8px;\n	color: #333;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #444;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #333;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #fcc500;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n	background-color: #fff;\n	padding: 4px;\n	margin-top: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	line-height: 16px;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #333;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	margin: 0;\n	padding: 8px 4px;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #333;\n	background-color: #f0f0f0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #333;\n	text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #333;\n	text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-player-wrapper {\n	display: block;\n	position: relative;\n	background-color: #fff;\n	padding: 4px;\n}\n\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-wrapper {\n	display: block;\n	position: relative;\n	background-color: #fff;\n	padding: 0;\n	margin-top: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-title {\n	font:14px Open Sans,Arial,sans-serif;\n	margin: 0;\n	padding: 8px;\n	color: #333;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item {\n	list-style-type: none;\n	position: relative;\n	color: #333;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	margin: 0;\n	padding: 8px 4px;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item:hover{\n	color: #333;\n	background-color: #f0f0f0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-shoutcast-time {\n    font-size: 13px;\n    width: 90px;\n    display: block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-shoutcast-title {\n    display:block;\n    font-size:13px;\n    margin-left:90px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-image {\n    width: 60px;\n    display: block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-text {\n    display:block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-title {\n    font-size: 13px;\n    margin: 4px;\n    padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-artist {\n    font-size: 12px;\n    margin: 4px;\n    padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 8px 0 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	whiteboxlive: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image img {\n	display: inline-block;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	text-align: left;\n	overflow: hidden;\n	padding: 8px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	font-family: Open Sans,Arial,sans-serif;\n	font-size: 14px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	color: #666;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	position: relative;\n	width: auto;\n	float: left;\n	padding: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #eee;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #444;\n	margin: 8px 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #666;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	background-color: #fcc500;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #fff;\n	font: bold 12px Open Sans, sans-serif;\n	margin: 8px;\n	color: #333;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #444;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #333;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #fcc500;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n	background-color: #fff;\n	padding: 4px;\n	margin-top: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	line-height: 16px;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #333;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	margin: 0;\n	padding: 8px 4px;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #333;\n	background-color: #f0f0f0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #333;\n	text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #333;\n	text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-player-wrapper {\n	display: block;\n	position: relative;\n	background-color: #fff;\n	padding: 4px;\n}\n\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-wrapper {\n	display: block;\n	position: relative;\n	background-color: #fff;\n	padding: 0;\n	margin-top: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-title {\n	font:14px Open Sans,Arial,sans-serif;\n	margin: 0;\n	padding: 8px;\n	color: #333;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item {\n	list-style-type: none;\n	position: relative;\n	color: #333;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	margin: 0;\n	padding: 8px 4px;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item:hover{\n	color: #333;\n	background-color: #f0f0f0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-shoutcast-time {\n    font-size: 13px;\n    width: 90px;\n    display: block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-shoutcast-title {\n    display:block;\n    font-size:13px;\n    margin-left:90px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-image {\n    width: 60px;\n    display: block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-text {\n    display:block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-title {\n    font-size: 13px;\n    margin: 4px;\n    padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-artist {\n    font-size: 12px;\n    margin: 4px;\n    padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 8px 0 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	greybox: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image img {\n	display: inline-block;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	text-align: left;\n	overflow: hidden;\n	padding: 8px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #fff;\n	font-family: Open Sans,Arial,sans-serif;\n	font-size: 14px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	color: #ddd;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	position: relative;\n	width: auto;\n	float: left;\n	padding: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #eee;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #222;\n	margin: 8px 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #999;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	background-color: #fcc500;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #fff;\n	font: bold 12px Open Sans, sans-serif;\n	margin: 8px;\n	color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #444;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #fcc500;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n	background-color: #333;\n	padding: 4px;\n	margin-top: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	line-height: 16px;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #f0f0f0;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	margin: 0;\n	padding: 8px 4px;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #fff;\n	background-color: #666;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #444;\n	text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #444;\n	text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-player-wrapper {\n	display: block;\n	position: relative;\n	background-color: #333;\n	padding: 4px;\n}\n\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-wrapper {\n	display: block;\n	position: relative;\n	background-color: #444;\n	padding: 0;\n	margin-top: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-title {\n	font:14px Open Sans,Arial,sans-serif;\n	margin: 0;\n	padding: 8px;\n	color: #fff;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item {\n	list-style-type: none;\n	position: relative;\n	color: #fff;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	margin: 0;\n	padding: 8px 4px;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item:hover{\n	color: #f0f0f0;\n	background-color: #555;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-shoutcast-time {\n    font-size: 13px;\n    width: 90px;\n    display: block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-shoutcast-title {\n    display:block;\n    font-size:13px;\n    margin-left:90px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-image {\n    width: 60px;\n    display: block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-text {\n    display:block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-title {\n    font-size: 13px;\n    margin: 4px;\n    padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-artist {\n    font-size: 12px;\n    margin: 4px;\n    padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 8px 0 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #eee;\n}'
	},
	greyboxlive: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	margin: 4px;\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image img {\n	display: inline-block;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	text-align: left;\n	overflow: hidden;\n	padding: 8px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #fff;\n	font-family: Open Sans,Arial,sans-serif;\n	font-size: 14px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	color: #ddd;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	position: relative;\n	width: auto;\n	float: left;\n	padding: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n	position: relative;\n	float: left;\n	color: #eee;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: relative;\n	float: left;\n	margin: 0 2px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: relative;\n	background-color: #222;\n	margin: 8px 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #999;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	background-color: #fcc500;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: relative;\n	float: right;\n	color: #fff;\n	font: bold 12px Open Sans, sans-serif;\n	margin: 8px;\n	color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #444;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #fcc500;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n	background-color: #333;\n	padding: 4px;\n	margin-top: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	line-height: 16px;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #f0f0f0;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	margin: 0;\n	padding: 8px 4px;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #fff;\n	background-color: #666;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #444;\n	text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #444;\n	text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-player-wrapper {\n	display: block;\n	position: relative;\n	background-color: #333;\n	padding: 4px;\n}\n\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-wrapper {\n	display: block;\n	position: relative;\n	background-color: #444;\n	padding: 0;\n	margin-top: 8px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-title {\n	font:14px Open Sans,Arial,sans-serif;\n	margin: 0;\n	padding: 8px;\n	color: #fff;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item {\n	list-style-type: none;\n	position: relative;\n	color: #fff;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	margin: 0;\n	padding: 8px 4px;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item:hover{\n	color: #f0f0f0;\n	background-color: #555;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-shoutcast-time {\n    font-size: 13px;\n    width: 90px;\n    display: block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-shoutcast-title {\n    display:block;\n    font-size:13px;\n    margin-left:90px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-image {\n    width: 60px;\n    display: block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-text {\n    display:block;\n    float:left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-title {\n    font-size: 13px;\n    margin: 4px;\n    padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playedlist-item-radionomy-artist {\n    font-size: 12px;\n    margin: 4px;\n    padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 8px 0 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #eee;\n}'
	},
	lightbox: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n	display: block;\n	position: relative;\n	background-color: #f1f1f1;\n	margin: 0px;\n	padding: 0px;\n	-moz-box-shadow: 0 0 5px 0 rgba(0, 0, 0, 0.1);\n	-webkit-box-shadow: 0 0 5px 0 rgba(0, 0, 0, 0.1);\n	box-shadow: 0 0 5px 0 rgba(0, 0, 0, 0.1);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-player-wrapper {\n	overflow: hidden;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	background-color: #fbfaf6;\n	background-image: -moz-linear-gradient(top,  #fbfaf6 0%, #d7d5cd 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0%,#fbfaf6), color-stop(100%,#d7d5cd)); \n	background-image: -webkit-linear-gradient(top,  #fbfaf6 0%,#d7d5cd 100%); \n	background-image: -o-linear-gradient(top,  #fbfaf6 0%,#d7d5cd 100%);\n	background-image: -ms-linear-gradient(top,  #fbfaf6 0%,#d7d5cd 100%);\n	background-image: linear-gradient(to bottom,  #fbfaf6 0%,#d7d5cd 100%);\n	filter: progid:DXImageTransform.Microsoft.gradient( startColorstr="#fbfaf6", endColorstr="#d7d5cd",GradientType=0 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	margin: 0;\n	padding 0;\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image img {\n	display: inline-block;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	overflow: hidden;\n	width: 100%;\n	height: auto;\n	text-align: center;\n	z-index: 1;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #333;\n	padding: 8px 24px 0px;\n	font-family: "Noto Sans",Arial,sans-serif;\n	font-size: 15px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	color: #555;\n	padding: 2px 24px;\n	font-family: Arial, sans-serif;\n	font-size: 12px;\n	font-style: italic;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	display: block;\n	position: relative;\n	width: 100%;\n	height: 56px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: absolute;\n	left: 50%;\n	margin-left: -24px;\n	top: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: absolute;\n	left: 50%;\n	margin-left: -72px;\n	top: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: absolute;\n	left: 50%;\n	margin-left: 24px;\n	top: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: absolute;\n	top: 14px;\n	left: 50%;\n	margin-left: 72px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: absolute;\n	z-index: 1;	\n	left: 0px;	\n	top: 180px;\n	background-color: #dad6b4;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #bab49a;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	background-color: #fcc500;\n	background-image: -ms-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -moz-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -o-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #fede00), color-stop(1, #fcc500));\n	background-image: -webkit-linear-gradient(top, #fede00 0%, #fcc500 100%); \n	background-image: linear-gradient(to bottom, #fede00 0%, #fcc500 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: absolute;\n	top: 14px;\n	left: 8px;\n	color: #434548;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	line-height: 24px;\n	margin: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: absolute;\n	top: 14px;\n	left: 50%;\n	margin-left: 100px;\n	z-index: 2;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #d5cea6;\n	background-image: -moz-linear-gradient(-45deg,  #d5cea6 0%, #c9c190 100%);\n	background-image: -webkit-gradient(linear, left top, right bottom, color-stop(0%,#d5cea6), color-stop(100%,#c9c190));\n	background-image: -webkit-linear-gradient(-45deg,  #d5cea6 0%,#c9c190 100%);\n	background-image: -o-linear-gradient(-45deg,  #d5cea6 0%,#c9c190 100%);\n	background-image: -ms-linear-gradient(-45deg,  #d5cea6 0%,#c9c190 100%);\n	background-image: linear-gradient(135deg,  #d5cea6 0%,#c9c190 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #bab49a;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #666;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n	margin-top: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	-webkit-border-radius: 4px;\n   	 -moz-border-radius: 4px;\n    	border-radius: 4px;\n	padding: 12px 12px 16px;\n	background-color: #fbfaf6;\n	background-image: -ms-linear-gradient(top, #fbfaf6 0%, #d7d5cd 100%);\n	background-image: -moz-linear-gradient(top, #fbfaf6 0%, #d7d5cd 100%);\n	background-image: -o-linear-gradient(top, #fbfaf6 0%, #d7d5cd 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #fbfaf6), color-stop(1, #d7d5cd));\n	background-image: -webkit-linear-gradient(top, #fbfaf6 0%, #d7d5cd 100%);\n	background-image: linear-gradient(to bottom, #fbfaf6 0%, #d7d5cd 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #666;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #222;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #666;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #222;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	musicbox: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n	display: block;\n	position: relative;\n	background-color: #333;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n    	-moz-border-radius: 2px;\n    	border-radius: 2px;\n	margin: 0px;\n	padding: 0px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-player-wrapper {\n	padding: 4px;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n	display: block;\n	position: relative;\n	float: left;\n	top: 0;\n	left: 0;\n	margin: 4px;\n	overflow: hidden;\n	-webkit-box-shadow: 0 8px 6px -6px black;\n	-moz-box-shadow: 0 8px 6px -6px black;\n	box-shadow: 0 8px 6px -6px black;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image img {\n	display: inline-block;\n	margin: 0;\n	padding: 0;\n	-webkit-border-radius: 4px;\n    	-moz-border-radius: 4px;\n    	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n	display: block;\n	position: relative;\n	top: 0;\n	left: 0;\n	text-align: left;\n	overflow: hidden;\n	padding: 4px 12px;\n	height: auto;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n	display: block;\n	color: #fff;\n	font-family: "Noto Sans",Arial,sans-serif;\n	font-size: 14px;\n	font-weight: bold;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n	display: block;\n	color: #ddd;\n	font-family: Arial, sans-serif;\n	font-size: 11px;\n	font-style: italic;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n	display: block;\n	position: relative;\n	height: 96px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	position: absolute;\n	left: 145px;\n	top: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n	position: relative;\n	float: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: absolute;\n	left: 110px;\n	top: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: absolute;\n	left: 180px;\n	top: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n	position: absolute;\n	top: 12px;\n	left: 238px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n	position: absolute;\n	left: 0;\n	top: 46px;\n	right: 0;\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	margin: 8px 4px;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n	background-color: #444;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	background-color: #fcc500;\n	background-image: -ms-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -moz-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -o-linear-gradient(top, #fede00 0%, #fcc500 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #fede00), color-stop(1, #fcc500));\n	background-image: -webkit-linear-gradient(top, #fede00 0%, #fcc500 100%); \n	background-image: linear-gradient(to bottom, #fede00 0%, #fcc500 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n	position: absolute;\n	top: 64px;\n	left: 0;\n	color: #a0a0a0;\n	font-family: Open Sans, sans-serif;\n	font-size: 12px;\n	text-shadow:3px 5px 10px #000;\n	line-height: 24px;\n	margin: 0 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n	position: absolute;\n	top: 12px;\n	left: 265px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n	background-color: #333;\n	border: none;\n	-webkit-border-radius: 4px;\n	-moz-border-radius: 4px;\n	border-radius: 4px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n	background-color: #222;\n	-webkit-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	-moz-box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n	box-shadow: -1px -1px 0 rgba( 0, 0, 0, 0.5 ), 1px 1px 0 rgba( 255, 255, 255, 0.1 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n	background-color: #fcc500;\n	-webkit-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	-moz-box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n	box-shadow: inset 0 0 5px rgba( 255, 255, 255, 0.5 );\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n	display: block;\n	position: relative;\n	top: 168px;\n	left: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n	display: block;\n	position: relative;\n	background-color: #333;\n	border: 1px solid #222;\n	-webkit-border-radius: 2px;\n    	-moz-border-radius: 2px;\n    	border-radius: 2px;\n	margin: 0px;\n	padding: 12px 12px 16px;\n	-webkit-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	-moz-box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	box-shadow: inset 0 1px 0 rgba( 255, 255, 255, 0.15 ), 0 0 3px rgba( 0, 0, 0, 0.5 );\n	background-image: -ms-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -moz-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -o-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: -webkit-gradient(linear, left top, left bottom, color-stop(0, #444444), color-stop(1, #111111));\n	background-image: -webkit-linear-gradient(top, #444444 0%, #111111 100%);\n	background-image: linear-gradient(to bottom, #444444 0%, #111111 100%);\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n	position: relative;\n	list-style-type: none;\n	margin: 0;\n	padding: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n	position: relative;\n	cursor: pointer;\n	color: #999;\n	font-family: Open Sans, Arial, sans-serif;\n	font-size: 12px;\n	text-shadow: 0 1px 1px rgba(0, 0, 0, 0.6);\n	line-height: 22px;\n	margin: 0;\n	padding: 0;\n	text-align: left;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n	cursor: pointer;\n	color: #fff;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n	color: #999;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n	color: #fff;\n    text-decoration: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n	position: absolute;\n	top: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: -64px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n	position: absolute;\n	bottom: 2px;\n	left: 50%;\n	margin-left: 16px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n	clear: both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px 0;\n	top: 168px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #eee;\n}'
	},
	threebuttons: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n	padding-right: 48px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n	clear:both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n	clear:both;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n	float: left;\n	margin-left: 24px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n	position: absolute;\n	left: 0;\n	right: 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n	position: relative;\n	margin-left: 48px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	button24: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	button48: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	buttonblue: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	},
	blueplaystop: {
		skincss: '#amazingaudioplayer-AUDIOPLAYERID {\n	box-sizing: content-box;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID div {\n	-webkit-box-sizing: content-box;\n	-moz-box-sizing: content-box;\n	box-sizing: content-box;   \n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-image-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-text-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-title-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-info-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-buttons-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-bar-title {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-playpause {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-play {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-pause {\n	position: relative;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-stop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-prev {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-next {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-loop {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-loaded {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-progress-played {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-time {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-volume-bar-adjust-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-container {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks-wrapper {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracks {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item {\n	clear: both;\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-active a {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item-duration {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-prev {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-arrow-next {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklist-clear {\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-id {\n	float: left;\n	margin: 0 8px 0 0;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-info {\n	float: right;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-item-title {\n	overflow: hidden;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:before,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-track-item:after {\n	display: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID ul,\n#amazingaudioplayer-AUDIOPLAYERID li {\n	list-style-type: none;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch {\n	box-sizing: border-box;\n	padding: 4px;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tracklistsearch-input {\n	box-sizing: border-box;\n	width: 100%;\n}\n\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-play:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-pause:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-prev:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-next:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-loop:focus,\n#amazingaudioplayer-AUDIOPLAYERID .amazingaudioplayer-tabindex .amazingaudioplayer-volume-button:focus {\n\toutline:1px solid #666;\n}'
	}
};

var WONDERAUDIO_NEWTEMPS = ['darkbox', 'jukebox', 'barwithplaylist', 'barwhitewithplaylist', 'whitebox', 'greybox'];
for (var i = 0; i< WONDERAUDIO_NEWTEMPS.length; i++)
{
	var skin = WONDERAUDIO_NEWTEMPS[i];
	WONDERPLUGIN_AUDIO_SKIN_TEMPLATE[skin + "withdownload"] = {};
	for (var key in WONDERPLUGIN_AUDIO_SKIN_TEMPLATE[skin])
	{
		WONDERPLUGIN_AUDIO_SKIN_TEMPLATE[skin + "withdownload"][key] = WONDERPLUGIN_AUDIO_SKIN_TEMPLATE[skin][key];
	}		
}
