<?php

/**
 * Shortcoder - Revisions
 */

if( ! defined( 'ABSPATH' ) ) exit;

class Shortcoder_Revisions{

    public static function init(){

        add_filter( 'sc_mod_post_type_args', array( __CLASS__, 'enable_revisions' ), 10, 1 );

        add_filter( 'wp_revisions_to_keep', array( __CLASS__, 'revisions_keep' ), 10, 2 );

    }

    public static function enable_revisions( $args ){

        $settings = Shortcoder::get_settings();
        if( $settings[ 'revisions' ] == 'no' ){
            return $args;
        }

        $supports = $args[ 'supports' ];
        $supports = ($supports === false) ? array() : $supports;

        if( is_array( $supports ) ){
            array_push( $supports, 'revisions' );
        }

        $args[ 'supports' ] = $supports;
        return $args;

    }

    public static function revisions_keep( $num, $post ){

        if( !is_object( $post ) || $post->post_type != SC_POST_TYPE ) {
            return $num;
        }

        $settings = Shortcoder::get_settings();
        if ( $settings[ 'revisions_keep' ] == '0' ){
            return $num;
        }

        return $settings[ 'revisions_keep' ];

    }

}

Shortcoder_Revisions::init();

?>