<?php

/**
 * Shortcoder - PRO
 */

class Shortcoder_Pro{

    public static $license;

    public static function init(){

        self::includes();

        self::$license = new SC_PRO\AW_Plugin_License_Manager(array(
            'id' => 'shortcoder-pro',
            'name' => 'Shortcoder - Pro',
            'version' => SC_VERSION,
            'file' => 'shortcoder-pro/shortcoder.php',
            'prefix' => 'shortcoder_',
            'slug' => 'shortcoder-pro',
            'license_page' => 'shortcoder_license_page',
            'home_url' => 'https://www.aakashweb.com/wordpress-plugins/shortcoder/',
            'dev' => false
        ));

        add_action( 'admin_menu', array( __CLASS__, 'license_page_menu' ), 30 );

        add_filter( 'sc_mod_sc_settings', array( __CLASS__, 'pro_sc_settings_list' ) );

        add_filter( 'sc_mod_settings', array( __CLASS__, 'pro_settings_list' ) );

        add_filter( 'init', array( __CLASS__, 'load_textdomain' ) );

    }

    public static function includes(){

        include_once( SC_PATH . 'pro/license-manager/class-aw-plugin-license-manager.php' );
        include_once( SC_PATH . 'pro/revisions/index.php' );
        include_once( SC_PATH . 'pro/custom-editor/index.php' );
        include_once( SC_PATH . 'pro/extra-code/index.php' );
        include_once( SC_PATH . 'pro/locate-shortcode/index.php' );

    }

    public static function pro_sc_settings_list( $settings ){

        $settings[ '_sc_custom_editor_id' ] = '';
        $settings[ '_sc_extra_code' ] = '';

        return $settings;

    }

    public static function pro_settings_list( $settings ){

        $settings[ 'revisions' ] = 'no';
        $settings[ 'revisions_keep' ] = '0';

        return $settings;

    }

    public static function license_page_menu(){

        $notification = '';

        if( self::notify_license() ){
            $notification = ' <span class="update-plugins">1</span>';
        }

        add_submenu_page( 'edit.php?post_type=shortcoder', 'License', 'License & Updates' . $notification, 'manage_options', 'shortcoder_license_page', array( self::$license, 'license_page' ) );

    }

    public static function notify_license(){

        $notify = false;

        if( self::$license->is_license_set() ){
            if( self::$license->has_license_expired() ){
                $notify = true;
            }
        }else{
            $notify = true;
        }

        return $notify;

    }

    public static function load_textdomain(){

        $domain = 'shortcoder';
        $locale = apply_filters( 'plugin_locale', determine_locale(), $domain );
        $plugin_rel_path = dirname( SC_BASE_NAME ) . '/languages';
        $mo_file = $domain . '-' . $locale . '.mo';

        load_textdomain( $domain, WP_PLUGIN_DIR . '/' . $plugin_rel_path . '/' . $mo_file, $locale );

    }

}

Shortcoder_Pro::init();

?>