<?php

/**
 * Shortcoder - Locate shortcode
 */

if( ! defined( 'ABSPATH' ) ) exit;

class Shortcoder_Locate_Shortcode{

    public static function init(){

        add_action( 'wp_ajax_sc_locate_shortcode', array( __CLASS__, 'api' ) );

        add_action( 'add_meta_boxes', array( __CLASS__, 'add_meta_boxes' ) );

    }

    public static function api(){

        global $wpdb;

        check_admin_referer( 'sc_locate_shortcode' );

        if( !isset( $_POST[ 'lsc_id' ] ) ){
            wp_die();
        }

        $sc_id = sanitize_key( $_POST[ 'lsc_id' ] );
        $f_post_type = isset( $_POST[ 'lsc_post_type' ] ) ? sanitize_key( $_POST[ 'lsc_post_type' ] ) : false;
        $f_post_status = isset( $_POST[ 'lsc_post_status' ] ) ? sanitize_key( $_POST[ 'lsc_post_status' ] ) : false;

        $sc_post = get_post( $sc_id );

        if( !$sc_post ){
            wp_send_json( array() );
            wp_die();
        }

        $query = "SELECT * FROM $wpdb->posts WHERE post_type <> 'revision' ";
        $args = array();

        if( $f_post_type && !empty( $f_post_type ) ){
            $query .= " AND {$wpdb->posts}.post_type = %s";
            array_push( $args, $f_post_type );
        }

        if( $f_post_status && !empty( $f_post_status ) ){
            $query .= " AND {$wpdb->posts}.post_status = %s";
            array_push( $args, $f_post_status );
        }

        $query .= " AND {$wpdb->posts}.post_content LIKE %s";
        array_push( $args, '%[sc%name="' . $sc_post->post_name . '"%' );

        $raw_results = $wpdb->get_results( $wpdb->prepare( $query, $args ) );
        $results = array();

        foreach( $raw_results as $result ){
            array_push( $results, array(
                'id' => $result->ID,
                'title' => $result->post_title,
                'url' => admin_url( 'post.php?action=edit&post=' . $result->ID ),
                'post_type' => $result->post_type
            ));
        }

        wp_send_json( $results );

        wp_die();

    }

    public static function add_meta_boxes(){

        add_meta_box( 'sc_mb_locate_shortcode', __( 'Locate shortcode', 'shortcoder' ), array( __CLASS__, 'form' ), SC_POST_TYPE, 'side', 'default' );

    }

    public static function form( $post ){

        echo '<p>' . esc_html__( 'Search for posts where this shortcode is inserted', 'shortcoder' ) . '</p>';

        echo '<div class="sc_lc_wrap">';
        echo '<div class="sc_lc_form">';
        echo '<input type="hidden" class="lsc_id" value="' . esc_attr( $post->ID ) . '" />';
        echo '<input type="hidden" class="lsc_nonce" value="' . esc_attr( wp_create_nonce( 'sc_locate_shortcode' ) ) . '" />';

        echo '<table class="widefat">';
        echo '<tbody>';
            echo '<tr>';
            echo '<td><label>' . esc_html__( 'Post type', 'shortcoder' ) . '</label>';
            echo self::post_type_selector() . '</td>';
            echo '</tr>';
            echo '<tr>';
            echo '<td><label>' . esc_html__( 'Status', 'shortcoder' ) . '</label>';
            echo self::post_status_selector() . '</td>';
            echo '</tr>';
        echo '</tbody>';
        echo '<tfoot>';
            echo '<tr>';
            echo '<td>' . '<button class="button sc_lc_button">' . esc_html__( 'Locate this shortcode', 'shortcoder' ) . '</button>' . '</td>';
            echo '</tr>';
        echo '</tfoot>';
        echo '</table>';

        echo '</div>';
        echo '<div class="sc_lc_results">';
        echo '<p class="sc_lc_summary"></p>';
        echo '<ul></ul>';
        echo '</div>';
        echo '</div>';

    }

    public static function post_type_selector(){

        $post_types = get_post_types( array(), 'objects' );

        $html = '<select class="lsc_post_type widefat">';
        $html .= '<option value="">' . esc_html__( 'All post types', 'shortcoder' ) . '</option>';
        foreach( $post_types as $post_type => $props ){
            if( $post_type == 'revision' ){
                continue;
            }
            $text = $props->label;
            $html .= '<option value="' . esc_attr( $post_type ) . '">' . esc_html( $text ) . '</option>';
        }
        $html .= '</select>';
        return $html;

    }

    public static function post_status_selector(){

        $post_status = get_post_statuses();

        $html = '<select class="lsc_post_status widefat">';
        $html .= '<option value="">' . esc_html__( 'Any status', 'shortcoder' ) . '</option>';
        foreach( $post_status as $status => $label ){
            $html .= '<option value="' . esc_attr( $status ) . '">' . esc_html( $label ) . '</option>';
        }
        $html .= '</select>';
        return $html;

    }

}

Shortcoder_Locate_Shortcode::init();

?>