<?php defined( 'ABSPATH' ) || exit; ?>

<?php
$submit_btn = $is_license_set ? __( 'Deactivate license', 'awp_lm' ) : __( 'Activate license', 'awp_lm' );
$form_action = $is_license_set ? 'deactivate' : 'activate';
$key_field_type = $is_license_set ? 'password' : 'text';
$key_field_readonly = $is_license_set ? 'readonly="readonly"' : '';
?>

<div class="wrap">
    <h1><?php echo $p_title ?></h1>
    <h2><?php _e( 'License information', 'awp_lm' ); ?></h2>
    <p>Enter your license key below to activate the plugin and enable plugin updates. You can get the license key from the purchase receipt email or from your <a href="https://www.aakashweb.com/my-account" target="_blank">my account</a> page.</p>
    <p>If there is any issue or queries while activating, deactivating license or installing latest updates, please <a href="https://www.aakashweb.com/contact" target="_blank">contact Aakash Web</a></p>
    <form method="post">
        <div class="postbox">
            <div class="inside">
            <table class="form-table">
                <tbody>
                    <tr>
                        <th><?php _e( 'License key', 'awp_lm' ); ?></th>
                        <td><input type="<?php echo $key_field_type; ?>" <?php echo $key_field_readonly; ?> class="widefat" name="license_key" value="<?php echo $license_key; ?>" /></td>
                    </tr>
                    <tr>
                        <th></th>
                        <td><button type="submit" class="button button-primary"><?php echo $submit_btn; ?></button></td>
                    </tr>
                    
                </tbody>
            </table>
            </div>
        </div>
        <input type="hidden" name="license_action" value="<?php echo $form_action; ?>" />
        <?php wp_nonce_field( $p_nonce ); ?>
    </form>
    
    <?php if( $is_license_set ): ?>
    <h3>Update information</h3>
    <div class="postbox">
        <div class="inside">
            <table class="form-table">
                <tbody>
                    <tr>
                        <th>Latest updates available till</th>
                        <td><?php echo get_date_from_gmt( $license_expiry, 'Y-m-d' ); ?>
                        <?php if( time() > strtotime( $license_expiry ) ) echo '<span style="color:red">(License expired)</span>'; ?>
                        <form method="post" style="display:inline; margin-left:20px">
                            <input type="hidden" name="license_action" value="refresh" />
                            <button class="button button-primary">Refresh</button>
                            <?php wp_nonce_field( $p_nonce ); ?>
                        </form>
                        </td>
                    </tr>
                    
                    <tr>
                        <th>Current version</th>
                        <td><?php echo $p_version; ?></td>
                    </tr>
                    
                    <?php if( isset( $update_info[ 'version' ] ) ): ?>
                    <tr>
                        <th>Latest version</th>
                        <td><?php echo $update_info[ 'version' ]; ?></td>
                    </tr>
                    
                        <?php if( version_compare( $update_info[ 'version' ], $p_version, '>' ) ): ?>
                        <tr>
                            <th></th>
                            <td><a href="<?php echo esc_url( admin_url( 'plugins.php?s=' . $p_title ) ); ?>" class="button button-primary" target="_blank">Update</a></td>
                        </tr>
                        <?php endif; ?>
                        
                    <?php endif; ?>
                    
                </tbody>
            </table>
        </div>
    </div>
    <?php endif; ?>
    <p class="description" align="right"><small><i style="opacity: 0.3">AW plugin license manager v<?php echo $license_manager_version; ?></i></small></p>
</div>