<?php

/**
 * Shortcoder - Extra Code
 */

if( ! defined( 'ABSPATH' ) ) exit;

class Shortcoder_Extra_Code{

    public static $active_shortcodes = array();

    public static function init(){

        add_filter( 'sc_mod_sc_settings_fields', array( __CLASS__, 'settings_field' ), 10, 2 );

        add_filter( 'sc_mod_skip_sanitize_sc_settings', array( __CLASS__, 'skip_sanitize' ) );

        add_action( 'sc_do_after', array( __CLASS__, 'track_usage' ), 10, 1 );

        add_action( 'wp_footer', array( __CLASS__, 'put_code' ) );

    }

    public static function settings_field( $fields, $settings ){

        $new_fields = array(

            array( __( 'Extra Code', 'shortcoder' ), SC_Admin_Form::field( 'textarea', array(
                'value' => $settings[ '_sc_extra_code' ],
                'name' => '_sc_extra_code',
                'class' => 'widefat',
                'rows' => '5',
                'helper' => __( 'Enter extra code to include in the footer of the page when this shortcode is used anywhere on the page.', 'shortcoder' )
            )))

        );

        return array_merge( $fields, $new_fields );

    }

    public static function skip_sanitize( $fields ){

        array_push( $fields, '_sc_extra_code' );
        return $fields;

    }

    public static function track_usage( $shortcode ){

        $sc_id = $shortcode[ 'id' ];

        if( !in_array( $sc_id, self::$active_shortcodes ) ){
            array_push( self::$active_shortcodes, $sc_id );
        }

    }

    public static function put_code(){

        foreach( self::$active_shortcodes as $sc_id ){
            $sc_settings = Shortcoder::get_sc_settings( $sc_id );
            $extra_code = trim( $sc_settings[ '_sc_extra_code' ] );
            if( empty( $extra_code ) ){
                continue;
            }
            echo $extra_code;
        }

    }

}

Shortcoder_Extra_Code::init();

?>