<?php

/**
 * Shortcoder - Custom Editor
 */

if( ! defined( 'ABSPATH' ) ) exit;

define( 'SC_CE_POST_TYPE', 'shortcoder_editor' );

class Shortcoder_Custom_Editor{

    public static function init(){

        self::includes();

        add_action( 'init', array( __CLASS__, 'register_post_type' ), 0 );

        add_action( 'wp_ajax_sc_editor_new', array( __CLASS__, 'new_sc_editor' ) );

        add_filter( 'sc_mod_shortcode', array( __CLASS__, 'mod_shortcode_content' ), 10, 1 );

        add_filter( 'sc_mod_editors', array( __CLASS__, 'mod_editors_list' ) );

        add_action( 'sc_do_after_editor', array( __CLASS__, 'insert_custom_editor' ), 10, 3 );

        add_action( 'admin_enqueue_scripts', array( __CLASS__, 'enqueue_scripts' ) );

        add_action( 'admin_menu', array( __CLASS__, 'custom_editor_menu' ), 10 );

        add_filter( 'post_row_actions', array( __CLASS__, 'row_action' ), 10, 2 );

    }

    public static function includes(){

        include_once( SC_PATH . 'pro/custom-editor/import.php' );

    }

    public static function register_post_type(){

        $labels = array(
            'name'                  => _x( 'Shortcoder Editor', 'Post Type General Name', 'shortcoder' ),
            'singular_name'         => _x( 'Shortcode Editor', 'Post Type Singular Name', 'shortcoder' ),
            'menu_name'             => __( 'Shortcoder Editor', 'shortcoder' ),
            'name_admin_bar'        => __( 'Shortcode Editor', 'shortcoder' ),
            'archives'              => __( 'Shortcode Archives', 'shortcoder' ),
            'attributes'            => __( 'Shortcode Attributes', 'shortcoder' ),
            'parent_item_colon'     => __( 'Parent Shortcode:', 'shortcoder' ),
            'all_items'             => __( 'All Shortcode editors', 'shortcoder' ),
            'add_new_item'          => __( 'Create shortcode editor', 'shortcoder' ),
            'add_new'               => __( 'Create shortcode editor', 'shortcoder' ),
            'new_item'              => __( 'New Shortcode editor', 'shortcoder' ),
            'edit_item'             => __( 'Edit Shortcode content', 'shortcoder' ),
            'update_item'           => __( 'Update Shortcode content', 'shortcoder' ),
            'view_item'             => __( 'View Shortcode content', 'shortcoder' ),
            'view_items'            => __( 'View Shortcode content', 'shortcoder' ),
        );

        $args = array(
            'label'                 => __( 'Shortcode Editor', 'shortcoder' ),
            'labels'                => $labels,
            'supports'              => array( 'title', 'editor', 'revisions' ),
            'taxonomies'            => array(),
            'hierarchical'          => false,
            'public'                => true,
            'show_ui'               => true,
            'show_in_menu'          => false,
            'menu_position'         => 25,
            'menu_icon'             => 'dashicons-shortcode',
            'show_in_admin_bar'     => false,
            'show_in_nav_menus'     => false,
            'can_export'            => true,
            'has_archive'           => false,
            'exclude_from_search'   => true,
            'publicly_queryable'    => true,
            'show_in_rest'          => true,
            'map_meta_cap'          => true,
            'capability_type'       => 'shortcoder',
        );

        register_post_type( SC_CE_POST_TYPE, $args );

    }

    public static function enqueue_scripts( $hook ){

        $screen = get_current_screen();

        if( $screen && $screen->post_type != SC_CE_POST_TYPE ){
            return false;
        }

        if( $hook == 'post.php' || $hook == 'post-new.php' ) {
            wp_enqueue_script( 'sc-admin-ce-js', SC_URL . 'pro/admin/js/script-ce.js', array( 'jquery' ), SC_VERSION );
        }

    }

    public static function new_sc_editor(){

        if( !check_admin_referer( 'sc_create_custom_editor' ) ){
            wp_die();
        }

        if( !isset( $_GET[ 'sc_id' ] ) ){
            wp_die();
        }

        $sc_id = sanitize_title( $_GET[ 'sc_id' ] );

        if( empty( $sc_id ) ){
            wp_die();
        }

        $existing_editor_id = get_post_meta( $sc_id, '_sc_custom_editor_id', true );
        if( $existing_editor_id ){
            self::send_editor_id_json( $existing_editor_id );
        }

        $editor_id = wp_insert_post(array(
            'post_title' => 'Editor for #' . $sc_id,
            'post_type' => SC_CE_POST_TYPE,
            'comment_status' => 'closed',
            'meta_input' => array(
                '_sc_id' => $sc_id
            )
        ));

        update_post_meta( $sc_id, '_sc_custom_editor_id', $editor_id );
        self::send_editor_id_json( $editor_id );

    }

    public static function mod_shortcode_content( $shortcode ){

        if( !is_array( $shortcode ) ){
            return $shortcode;
        }

        $settings = $shortcode[ 'settings' ];
        if( $settings[ '_sc_editor' ] != 'custom_editor' || empty( $settings[ '_sc_custom_editor_id' ] ) ){
            return $shortcode;
        }

        $editor_id = $settings[ '_sc_custom_editor_id' ];
        $editor_post = get_post( $editor_id );

        $shortcode[ 'content' ] = apply_filters( 'the_content', $editor_post->post_content );

        if( class_exists( '\Elementor\Plugin' ) ){
            $elementor_doc = \Elementor\Plugin::$instance->documents->get( $editor_id );
            if( $elementor_doc && $elementor_doc->is_built_with_elementor() ){
                $shortcode[ 'content' ] = \Elementor\Plugin::$instance->frontend->get_builder_content_for_display( $editor_id );
            }
        }

        // Insert WP Bakery custom CSS style
        if ( is_plugin_active( 'js_composer/js_composer.php' ) ) {
            $wpb_editor_status = get_post_meta( $editor_id, '_wpb_vc_js_status', true );
            if( !empty( $wpb_editor_status ) && $wpb_editor_status === 'true' ){
                $wpb_custom_css = get_post_meta( $editor_id, '_wpb_shortcodes_custom_css', true );
                if ( !empty( $wpb_custom_css ) ) {
                    $wpb_custom_css = strip_tags( $wpb_custom_css );
                    echo '<style type="text/css" data-type="vc_shortcodes-custom-css">';
                    echo wp_kses_data( $wpb_custom_css );
                    echo '</style>';
                }
            }
        }

        return $shortcode;

    }

    public static function mod_editors_list( $editors ){

        $editors[ 'custom_editor' ] = __( 'Custom Editor', 'shortcoder' );
        return $editors;

    }

    public static function insert_custom_editor( $post, $settings, $editor ){

        if( $editor[ 'active' ] == 'custom_editor' ){

            $editor_link = empty( $settings[ '_sc_custom_editor_id' ] ) ? '#' : admin_url( 'post.php?action=edit&post=' . $settings[ '_sc_custom_editor_id' ] );
            $nonce = esc_attr( wp_create_nonce( 'sc_create_custom_editor' ) );

            echo '<div class="sc_cm_menu">';
            echo '<div class="sc_editor_toolbar">';
            echo $editor[ 'switch_html' ];
            echo '</div>';
            echo '</div>';

            echo '<div class="sc_ce_placeholder">
                <div>
                    <a href="' . esc_url( $editor_link ) . '" class="button button-primary sc_open_ce_btn" target="_blank" data-sc-id="' . esc_attr( $post->ID ) . '" data-nonce="' . esc_attr( $nonce ) . '" title="' . esc_attr__( 'Open Editor', 'shortcoder' ) . '">
                    <span class="dashicons dashicons-edit"></span> ' . esc_html__( 'Open Editor', 'shortcoder' ) . '</a>
                </div>
            </div>';
        }

    }

    public static function send_editor_id_json( $editor_id ){

        wp_send_json(array(
            'editor_id' => $editor_id,
            'editor_url' => admin_url( 'post.php?action=edit&post=' . $editor_id )
        ));

        wp_die();

    }

    public static function row_action( $actions, $post ){

        if( ! current_user_can( 'edit_posts' ) ) {
            return $actions;
        }

        if( !is_object( $post ) || $post->post_type != SC_POST_TYPE ){
            return $actions;
        }

        $sc_settings = Shortcoder::get_sc_settings( $post->ID );

        if( $sc_settings[ '_sc_editor' ] == 'custom_editor' && !empty( $sc_settings[ '_sc_custom_editor_id' ] ) ){
            $actions[ 'custom_editor' ] = '<a href="' . esc_url( admin_url( 'post.php?action=edit&post=' . $sc_settings[ '_sc_custom_editor_id' ] ) ) . '" target="_blank">' . esc_html__( 'Open custom editor', 'shortcoder' ) . '</a>';
        }

        return $actions;

    }

    public static function custom_editor_menu(){
        add_submenu_page( 'edit.php?post_type=shortcoder', 'Shortcoder - Custom editor', 'Custom editors', 'manage_options', admin_url( 'edit.php?post_type=shortcoder_editor' ), null );
    }

}

Shortcoder_Custom_Editor::init();

?>