<?php

/**
 * Shortcoder - Custom Editor import
 */

if( ! defined( 'ABSPATH' ) ) exit;

class Shortcoder_CE_Import{

    public static function init(){

        add_action( 'add_meta_boxes', array( __CLASS__, 'add_meta_boxes' ) );

        add_action( 'wp_ajax_sc_ce_import_to_ce', array( __CLASS__, 'import_to_ce' ) );

        add_action( 'wp_ajax_sc_ce_import_to_default', array( __CLASS__, 'import_to_default' ) );

    }

    public static function add_meta_boxes(){

        add_meta_box( 'sc_mb_ce_import_to_ce', __( 'Details', 'shortcoder' ), array( __CLASS__, 'meta_box_to_ce' ), SC_CE_POST_TYPE, 'side', 'default' );

        add_meta_box( 'sc_mb_ce_import_to_default', __( 'Custom editor', 'shortcoder' ), array( __CLASS__, 'meta_box_to_default' ), SC_POST_TYPE, 'side', 'default' );

        remove_meta_box( 'slugdiv', SC_CE_POST_TYPE, 'normal' );

        remove_meta_box( 'postcustom', SC_CE_POST_TYPE, 'normal' );

        remove_meta_box( 'pageparentdiv', SC_CE_POST_TYPE, 'side' );

    }

    public static function meta_box_to_ce( $post ){

        $sc_id = get_post_meta( $post->ID, '_sc_id', true );

        if( empty( $sc_id ) ){
            echo '<p>' . esc_html__( 'Cannot find the shortcode for this editor', 'shortcoder' ) . '</p>';
            return;
        }

        $sc_post = get_post( $sc_id );

        echo '<p>' . esc_html__( 'This is the editor for shortcode', 'shortcoder' ) . ' <code>' . esc_html( $sc_post->post_name ) . '</code></p>';

        echo '<p><button class="button sc_ce_import_to_ce" data-nonce="' . esc_attr( wp_create_nonce( 'sc_ce_import' ) ) . '" data-sc-id="' . esc_attr( $sc_id ) . '">' . esc_html__( 'Import content', 'shortcoder' ) . '</button></p>';

    }

    public static function meta_box_to_default( $post ){

        $sc_ce_id = get_post_meta( $post->ID, '_sc_custom_editor_id', true );

        if( empty( $sc_ce_id ) ){
            echo '<p>' . esc_html__( 'No custom editor is assigned for this shortcode.', 'shortcoder' ) . '</p>';
            return;
        }

        echo '<p>' . esc_html__( 'This shortcode has a custom editor. ', 'shortcoder' ) . '<a href="' . esc_url( admin_url( 'post.php?action=edit&post=' . $sc_ce_id ) ) . '" target="_blank">' . esc_html__( 'Open', 'shortcoder' ) . '</a>' . '</p>';

        echo '<p><button class="button sc_ce_import_to_default" data-nonce="' . esc_attr( wp_create_nonce( 'sc_ce_import' ) ) . '" data-sc-ce-id="' . esc_attr( $sc_ce_id ) . '">' . esc_html__( 'Import content from Custom Editor', 'shortcoder' ) . '</button></p>';

    }

    public static function import_to_ce(){

        if( !check_admin_referer( 'sc_ce_import' ) ){
            wp_die();
        }

        $sc_id = sanitize_text_field( $_POST[ 'sc_id' ] );

        if( !$sc_id ){
            self::send_response( -1, __( 'Invalid shortcode ID to import from', 'shortcoder' ) );
        }

        $ce_id = get_post_meta( $sc_id, '_sc_custom_editor_id', true );

        if( !$ce_id ){
            self::send_response( -1, __( 'No custom editor is assigned', 'shortcoder' ) );
        }

        $sc_post = get_post( $sc_id );

        $ce_post = array(
            'ID' => $ce_id,
            'post_content' => $sc_post->post_content
        );

        if( wp_update_post( $ce_post ) ){
            self::send_response( 0, __( 'Shortcode content imported successfully', 'shortcoder' ) );
        }

    }

    public static function import_to_default(){

        if( !check_admin_referer( 'sc_ce_import' ) ){
            wp_die();
        }

        $sc_ce_id = sanitize_text_field( $_POST[ 'sc_ce_id' ] );

        if( !$sc_ce_id ){
            self::send_response( -1, __( 'Invalid shortcode custom editor ID to import from', 'shortcoder' ) );
        }

        $sc_id = get_post_meta( $sc_ce_id, '_sc_id', true );

        if( !$sc_id ){
            self::send_response( -1, __( 'Cannot find shortcode to import content to.', 'shortcoder' ) );
        }

        $sc_ce_post = get_post( $sc_ce_id );

        $sc_post = array(
            'ID' => $sc_id,
            'post_content' => $sc_ce_post->post_content
        );

        if( wp_update_post( $sc_post ) ){
            self::send_response( 0, __( 'Custom editor content imported successfully', 'shortcoder' ) );
        }

    }

    public static function send_response( $code, $message ){

        wp_send_json(array(
            'code' => $code,
            'message' => $message
        ));

        wp_die();

    }

}

Shortcoder_CE_Import::init();

?>