(function($){
$(document).ready(function(){

    var init = function(){

        if(typeof window.SC_EDITOR !== 'undefined' && typeof window.SC_EDITOR.active !== 'undefined' && window.SC_EDITOR.active == 'code'){

            var codemirror_loaded = load_codemirror();

            if(!codemirror_loaded){
                $('.sc_editor_toolbar').append('<p>Unable to load code editor. Please check browser console (press Ctrl+Shift+J) for errors or try deactivating any code editor related plugin/themes.</p>');
            }

            $('.sc_editor_toolbar').appendTo('.sc_cm_menu');

        }else{
            $('.sc_editor_toolbar').appendTo('.wp-media-buttons');
        }

        if(typeof window.SC_VARS !== 'undefined'){

            if(SC_VARS['screen']['base'] == 'edit'){
                var version = '<small>v' + SC_VARS['sc_version'] + '</small>';
                $('.wp-heading-inline').append(version);
                add_top_import_export_btn();
            }

        }

        $('.sc_params_list').appendTo('body');

    }

    var set_sc_preview_text = function(name){
        $('.sc_preview_text').text('[sc name="' + name + '"][/sc]');
    }

    var insert_in_editor = function(data){
        if(window.SC_EDITOR.active == 'code'){
            var doc = window.sc_cm.getDoc();
            doc.replaceRange(data, doc.getCursor());
        }else{
            send_to_editor(data);
        }
    }

    var copy_to_clipboard = function(str){
        var el = document.createElement('textarea');
        el.value = str;
        el.setAttribute('readonly', '');
        el.style.position = 'absolute';
        el.style.left = '-9999px';
        document.body.appendChild(el);
        el.select();
        document.execCommand('copy');
        document.body.removeChild(el);
    };

    var load_codemirror = function(){

        if(typeof window.SC_CODEMIRROR === 'undefined'){
            console.error('Shortcoder: Codemirror settings are not loaded');
            return false;
        }

        if(typeof window.wp === 'undefined' || typeof window.wp.codeEditor === 'undefined'){
            console.error('Shortcoder: codeEditor namespace is not available');
            return false;
        }

        var sc_mode_loaded = load_cm_sc_mode();
        var mode = sc_mode_loaded ? 'sc_mode' : 'htmlmixed';

        wp.codeEditor.defaultSettings.codemirror['mode'] = mode;

        var editor = wp.codeEditor.initialize(document.getElementById('sc_content'), window.SC_CODEMIRROR);

        editor.codemirror.setSize( null, 500 );
        editor.codemirror.on('change', function(){
            editor.codemirror.save();
        });

        window.sc_cm = editor.codemirror;

        return true;

    }

    var load_cm_sc_mode = function(){

        if(typeof wp.CodeMirror === 'undefined'){
            console.error('Shortcoder: CodeMirror library is not loaded/available');
            return false;
        }

        if(typeof wp.CodeMirror.overlayMode === 'undefined'){
            console.error('Shortcoder: CodeMirror overlay method is not available');
            return false;
        }

        try{
            wp.CodeMirror.defineMode('sc_mode', function(config, parserConfig){
                var sc_overlay = {
                    token: function(stream, state){
                        if(stream.match(/\$\$[a-z0-9A-Z:_\-]+\$\$/)){
                            return 'number sc_param';
                        }
                        if(stream.match(/%%.*?%%/)){
                            return 'atom sc_param';
                        }
                        if(stream.match(/\[(.+?)?\](?:(.+?)?\[\/\])?/)){
                            return 'string sc_param';
                        }
                        stream.next();
                    }
                };
                return wp.CodeMirror.overlayMode(wp.CodeMirror.getMode(config, parserConfig.backdrop || 'htmlmixed'), sc_overlay);
            });
        }catch(error){
            console.error('Shortcoder: Unable to load shortcoder mode.', error);
            return false;
        }

        return true;

    }

    var close_params_list = function(){
        $('.sc_params_list').hide();
    }

    var add_top_import_export_btn = function(){

        $('#screen-meta-links').prepend('<div class="screen-meta-toggle ie_top_link hide-if-no-js"><button aria-controls="import-export-tab" aria-expanded="false" class="show-settings button">Import / Export</button></div>');

        $('#screen-meta').append('<div id="import-export-tab" class="hidden"></div>');

        $('#ie_content > div').appendTo('#import-export-tab');

    }

    $('#post_name').on('change keyup', function(){
        set_sc_preview_text($(this).val());
    });

    $('.sc_editor').on('focus', function(){
        window.sc_old_editor = $(this).val();
    }).on('change', function(e){

        new_editor = $(this).val();
        response = confirm(SC_VARS.text_editor_switch_notice);

        if(!response){
            e.preventDefault();
            $(this).val(window.sc_old_editor);
            return false;
        }

        window.location = window.location + '&editor=' + $(this).val();

    });

    $('.sc_insert_param').on('click', function(e){
        
        e.preventDefault();
        
        var offset = $(this).offset();
        var mtop = offset.top + $(this).outerHeight();

        $('.sc_params_list').css({
            top: mtop,
            left: offset.left
        }).toggle();

    });

    $('.sc_wp_params li').on('click', function(){
        insert_in_editor('$$' + $(this).data('id') + '$$');
        close_params_list();
    });

    $('.sc_cp_btn').on('click', function(){

        var $cp_box = $('.sc_cp_box');
        var $cp_default = $('.sc_cp_default');
        var $cp_info = $('.sc_cp_info');
        var param_val = $cp_box.val().trim();
        var default_val = $cp_default.val().trim();

        if( param_val != '' && $cp_box[0].checkValidity() ){

            var the_code = '';
            if(default_val == ''){
                the_code = '%%' + param_val + '%%';
            }else{
                the_code = '%%' + param_val + ':' + default_val + '%%';
            }

            insert_in_editor(the_code);
            $cp_info.removeClass('red');
            close_params_list();
        }else{
            $cp_info.addClass('red');
        }

    });
    
    $('.sc_cf_btn').on('click', function(){

        var $cf_box = $('.sc_cf_box');
        var $cf_info = $('.sc_cf_info');
        var param_val = $cf_box.val().trim();

        if( param_val != '' && $cf_box[0].checkValidity() ){
            insert_in_editor('$$custom_field:' + param_val + '$$');
            $cf_info.removeClass('red');
            close_params_list();
        }else{
            $cf_info.addClass('red');
        }

    });

    $('.sc_copy').on('click', function(){
        copy_to_clipboard($('.sc_preview_text').text());
        $this = $(this);
        $this.addClass('copied');
        setTimeout(function() {
            $this.removeClass('copied');
        }, 3000);
    })

    $('.sc_copy_list').on('click', function(e){
        e.preventDefault();
        var $copy_field = $(this).siblings('.sc_copy_text');
        copy_to_clipboard($copy_field.val());
        $copy_field.addClass('copied');
        setTimeout(function() {
            $copy_field.removeClass('copied');
        }, 3000);
    });

    $('.sc_changelog .dismiss_btn').on('click', function(){
        var url = SC_VARS.ajax_url + '?action=sc_admin_ajax&do=close_changelog';
        $.get(url, function( data ){
            if(data.search( /done/g ) == -1){
                $( '.sc_changelog article' ).html('Failed to close window. <a href="' + url + '" target="_blank">Please click here to close</a>');
            }else{
                $( '.sc_changelog' ).fadeOut();
            }
        });
    });

    $('.sc_settings_link').on('click', function(e){
        e.preventDefault();
        $('html').animate({
            scrollTop: $("#sc_mb_settings").offset().top
        }, 1000, function(){
            $('input[name="post_title"]').focus();
        });
    });

    // PRO
    $('.sc_open_ce_btn').on('click', function(e){
        if($(this).attr('href') != '#'){
            return;
        }
        e.preventDefault();
        var $link = $(this);
        var sc_id = $(this).attr( 'data-sc-id' );
        var nonce = $(this).attr( 'data-nonce' );
        var url = SC_VARS.ajax_url + '?action=sc_editor_new&sc_id=' + sc_id + '&_wpnonce=' + nonce;

        $.get(url, function( data ){
            if(typeof data === 'object' && data.hasOwnProperty('editor_url')){
                $link.attr('href', data.editor_url);
                window.open(data.editor_url, '_blank');
            }
        });

    });

    $('.sc_lc_button').on('click', function(e){
        e.preventDefault();
        var nonce = $('.lsc_nonce').val();
        var url = SC_VARS.ajax_url + '?action=sc_locate_shortcode';

        $.post(url, {
            '_wpnonce': nonce,
            'lsc_id': $('.lsc_id').val(),
            'lsc_post_type': $('.lsc_post_type').val(),
            'lsc_post_status': $('.lsc_post_status').val(),
        }, function(data){
            $('.sc_lc_results').show();
            $('.sc_lc_results ul').empty();
            $('.sc_lc_summary').empty();

            $.each(data, function(index){
                var item = data[index];
                $('.sc_lc_results ul').append('<li><a href="' + item['url'] + '" title="Edit post" target="_blank">' + item['title'] + '<span>' + item[ 'post_type' ] + '</span></a></li>');
            });

            if(data.length == 0){
                $('.sc_lc_results ul').append('<li class="sc_lc_no_result">No posts matching the filter use this shortcode</li>');
            }

            $('.sc_lc_summary').text(data.length + ' items');

        });

    });

    $('.sc_ce_import_to_default').on('click', function(e){

        e.preventDefault();

        if(!confirm('Are you sure to want to import content from custom editor?')){
            return;
        }

        var nonce = $(this).attr('data-nonce');
        var sc_ce_id = $(this).attr('data-sc-ce-id');

        var url = window.ajaxurl + '?action=sc_ce_import_to_default';

        $.post(url, {
            '_wpnonce': nonce,
            'sc_ce_id': sc_ce_id
        }, function(data){
            if(typeof data === 'object' && data.code == 0){
                location.reload();
            }
        });

    });

    init();

});
})( jQuery );